/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.clustering.kmedoids.PAM;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.utilities.documentation.Reference;

@Reference(authors="A. P. Reynolds, G. Richards, B. de la Iglesia, V. J. Rayward-Smith", title="Clustering Rules: A Comparison of Partitioning and Hierarchical Clustering Algorithms", booktitle="J. Math. Model. Algorithms 5(4)", url="https://doi.org/10.1007/s10852-005-9022-1", bibkey="DBLP:journals/jmma/ReynoldsRIR06")
public class ReynoldsPAM<O>
extends PAM<O> {
    private static final Logging LOG = Logging.getLogger(ReynoldsPAM.class);
    private static final String KEY = ReynoldsPAM.class.getName();

    public ReynoldsPAM(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        new Instance(distQ, ids, assignment).run(medoids, this.maxiter);
        this.getLogger().statistics((Statistic)optd.end());
        return ReynoldsPAM.wrapResult(ids, assignment, medoids, "PAM Clustering");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V>
    extends PAM.Par<V> {
        @Override
        public ReynoldsPAM<V> make() {
            return new ReynoldsPAM(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends PAM.Instance {
        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int k = medoids.size();
            double tc = this.assignToNearestCluster((ArrayDBIDs)medoids);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
            }
            WritableDoubleDataStore tnearest = DataStoreUtil.makeDoubleStorage((DBIDs)this.ids, (int)3);
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            DBIDVar bestid = DBIDUtil.newVar();
            int iteration = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                double best = Double.POSITIVE_INFINITY;
                int bestcluster = -1;
                for (int pi = 0; pi < k; ++pi) {
                    double basecost = this.computeRemovalCost(pi, tnearest);
                    DBIDIter h = this.ids.iter();
                    while (h.valid()) {
                        double cpi = basecost + this.computeReassignmentCost((DBIDRef)h, tnearest);
                        if (cpi < best) {
                            best = cpi;
                            bestid.set((DBIDRef)h);
                            bestcluster = pi;
                        }
                        h.advance();
                    }
                }
                if (!(best < -1.0E-12 * tc)) break;
                medoids.set(bestcluster, (DBIDRef)bestid);
                double nc = this.assignToNearestCluster((ArrayDBIDs)medoids);
                if (LOG.isStatistics()) {
                    LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", nc));
                }
                if (nc > tc) {
                    if (nc - tc < 1.0E-7 * tc) {
                        LOG.warning((CharSequence)"PAM failed to converge (numerical instability?)");
                        break;
                    }
                    LOG.warning((CharSequence)("PAM failed to converge: costs increased by: " + (nc - tc) + " exepected a decrease by " + best));
                    break;
                }
                tc = nc;
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(KEY + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".final-cost", tc));
            }
            return tc;
        }

        protected double computeRemovalCost(int i, WritableDoubleDataStore tnearest) {
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                double n = this.nearest.doubleValue((DBIDRef)j);
                if (this.assignment.intValue((DBIDRef)j) == i) {
                    double s = this.second.doubleValue((DBIDRef)j);
                    cost += s - n;
                    tnearest.put((DBIDRef)j, s);
                } else {
                    tnearest.put((DBIDRef)j, n);
                }
                j.advance();
            }
            return cost;
        }

        protected double computeReassignmentCost(DBIDRef h, WritableDoubleDataStore tnearest) {
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                double cur;
                double dist = this.distQ.distance(h, (DBIDRef)j);
                if (dist < (cur = tnearest.doubleValue((DBIDRef)j))) {
                    cost += dist - cur;
                }
                j.advance();
            }
            return cost;
        }
    }
}

