/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.Algorithm;
import elki.clustering.kmeans.KMeans;
import elki.clustering.kmedoids.PAM;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.utilities.Priority;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Priority(value=-100)
public class SingleAssignmentKMedoids<O>
extends PAM<O> {
    private static final Logging LOG = Logging.getLogger(SingleAssignmentKMedoids.class);

    public SingleAssignmentKMedoids(Distance<? super O> distance, int k, KMedoidsInitialization<O> initializer) {
        super(distance, k, 0, initializer);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        new Instance(distQ, ids, assignment).run(medoids);
        this.getLogger().statistics((Statistic)optd.end());
        return SingleAssignmentKMedoids.wrapResult(ids, assignment, medoids, "PAM Clustering");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    extends PAM.Par<O> {
        @Override
        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(KMeans.INIT_ID, KMedoidsInitialization.class, this.defaultInitializer()).grab(config, x -> {
                this.initializer = x;
            });
        }

        @Override
        public SingleAssignmentKMedoids<O> make() {
            return new SingleAssignmentKMedoids(this.distance, this.k, this.initializer);
        }
    }

    protected static class Instance {
        DBIDs ids;
        DistanceQuery<?> distQ;
        WritableIntegerDataStore assignment;

        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            this.distQ = distQ;
            this.ids = ids;
            this.assignment = assignment;
        }

        protected double run(ArrayModifiableDBIDs medoids) {
            double tc = this.assignToNearestCluster(medoids);
            String key = this.getClass().getName().replace("$Instance", "");
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(key + ".initial-cost", tc));
                LOG.statistics((Statistic)new DoubleStatistic(key + ".final-cost", tc));
            }
            return tc;
        }

        protected double assignToNearestCluster(ArrayModifiableDBIDs means) {
            DBIDArrayMIter miter = means.iter();
            double cost = 0.0;
            DBIDIter it = this.ids.iter();
            while (it.valid()) {
                double mindist = this.distQ.distance((DBIDRef)miter.seek(0), (DBIDRef)it);
                int minindx = 0;
                miter.advance();
                while (miter.valid()) {
                    double dist = this.distQ.distance((DBIDRef)miter, (DBIDRef)it);
                    if (dist < mindist) {
                        minindx = miter.getOffset();
                        mindist = dist;
                    }
                    miter.advance();
                }
                this.assignment.put((DBIDRef)it, minindx);
                cost += mindist;
                it.advance();
            }
            return cost;
        }
    }
}

