/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids.initialization;

import elki.clustering.kmeans.initialization.KMeansPlusPlus;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.math.linearalgebra.VMath;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@References(value={@Reference(authors="M. Eug\u00e9nia Captivo", title="Fast primal and dual heuristics for the p-median location problem", booktitle="European Journal of Operational Research 52(1)", url="https://doi.org/10.1016/0377-2217(91)90336-T", bibkey="doi:10.1016/0377-2217(91)90336-T"), @Reference(authors="F. E. Maranzana", title="On the location of supply points to minimize transport costs", booktitle="Journal of the Operational Research Society 15.3", url="https://doi.org/10.1057/jors.1964.47", bibkey="doi:10.1057/jors.1964.47")})
public class AlternateRefinement<O>
implements KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(AlternateRefinement.class);
    private KMedoidsInitialization<O> inner;
    int maxiter;

    public AlternateRefinement(KMedoidsInitialization<O> inner, int maxiter) {
        this.inner = inner;
        this.maxiter = maxiter;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        ArrayModifiableDBIDs medoids = DBIDUtil.newArray((DBIDs)this.inner.chooseInitialMedoids(k, ids, distQ));
        DBIDArrayMIter miter = medoids.iter();
        k = medoids.size();
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)0);
        double[] cost = new double[k];
        double tc = AlternateRefinement.assignToNearestCluster((DBIDArrayIter)miter, ids, distQ, assignment, cost);
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".initial-cost", tc));
        }
        int iteration = 0;
        while (iteration < this.maxiter || this.maxiter <= 0) {
            ++iteration;
            boolean changed = false;
            for (int i = 0; i < k; ++i) {
                changed |= AlternateRefinement.findMedoid(ids, distQ, (IntegerDataStore)assignment, i, miter.seek(i), cost);
            }
            if (!changed || iteration == this.maxiter) break;
            double nc = VMath.sum((double[])cost);
            tc = AlternateRefinement.assignToNearestCluster((DBIDArrayIter)miter, ids, distQ, assignment, cost);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".iteration." + iteration + ".estimated-cost", nc));
                LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".iteration." + iteration + ".reassigned-cost", tc));
            }
            if (!(tc >= nc)) continue;
            break;
        }
        LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".refined-cost", tc));
        return medoids;
    }

    public static boolean findMedoid(DBIDs ids, DistanceQuery<?> distQ, IntegerDataStore assignment, int j, DBIDArrayMIter miter, double[] cost) {
        boolean changed = false;
        double bestm = cost[j];
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            if (!DBIDUtil.equal((DBIDRef)miter, (DBIDRef)iter) && assignment.intValue((DBIDRef)iter) == j) {
                double sum = 0.0;
                DBIDIter iter2 = ids.iter();
                while (iter2.valid() && sum < bestm) {
                    if (!DBIDUtil.equal((DBIDRef)iter, (DBIDRef)iter2) && assignment.intValue((DBIDRef)iter2) == j) {
                        sum += distQ.distance((DBIDRef)iter, (DBIDRef)iter2);
                    }
                    iter2.advance();
                }
                if (sum < bestm) {
                    miter.setDBID((DBIDRef)iter);
                    bestm = sum;
                    changed = true;
                }
            }
            iter.advance();
        }
        cost[j] = bestm;
        return changed;
    }

    public static double assignToNearestCluster(DBIDArrayIter miter, DBIDs ids, DistanceQuery<?> distQ, WritableIntegerDataStore assignment, double[] cost) {
        Arrays.fill(cost, 0.0);
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            int curindx;
            int minindx = curindx = assignment.intValue((DBIDRef)iditer);
            double mindist = distQ.distance((DBIDRef)iditer, (DBIDRef)miter.seek(curindx));
            miter.seek(0);
            while (miter.valid()) {
                double dist;
                if (miter.getOffset() != curindx && (dist = distQ.distance((DBIDRef)iditer, (DBIDRef)miter)) < mindist) {
                    minindx = miter.getOffset();
                    mindist = dist;
                }
                miter.advance();
            }
            assignment.put((DBIDRef)iditer, minindx);
            int n = minindx;
            cost[n] = cost[n] + mindist;
            iditer.advance();
        }
        return VMath.sum((double[])cost);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID INIT_P = new OptionID("kmedoids.inner.init", "Nested inner initialization.");
        public static final OptionID MAXITER_P = new OptionID("kmedoids.init.maxiter", "Refinement steps on initialization.");
        private KMedoidsInitialization<O> inner;
        int maxiter;

        public void configure(Parameterization config) {
            new ObjectParameter(INIT_P, KMedoidsInitialization.class, KMeansPlusPlus.class).grab(config, x -> {
                this.inner = x;
            });
            ((IntParameter)new IntParameter(MAXITER_P).setDefaultValue((Object)0)).grab(config, x -> {
                this.maxiter = x;
            });
        }

        public AlternateRefinement<O> make() {
            return new AlternateRefinement<O>(this.inner, this.maxiter);
        }
    }
}

