/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids.initialization;

import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.NumberVector;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.Parameterizer;

@References(value={@Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Clustering by means of Medoids", booktitle="Statistical Data Analysis Based on the L1-Norm and Related Methods", bibkey="books/misc/KauRou87"), @Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Partitioning Around Medoids (Program PAM)", booktitle="Finding Groups in Data: An Introduction to Cluster Analysis", url="https://doi.org/10.1002/9780470316801.ch2", bibkey="doi:10.1002/9780470316801.ch2"), @Reference(authors="R. A. Whitaker", title="A Fast Algorithm For The Greedy Interchange For Large-Scale Clustering And Median Location Problems", booktitle="INFOR: Information Systems and Operational Research 21(2)", url="https://doi.org/10.1080/03155986.1983.11731889", bibkey="doi:10.1080/03155986.1983.11731889")})
public class BUILD<O>
implements KMeansInitialization,
KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(BUILD.class);

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        if (relation.size() < k) {
            throw new AbortException("Database has less than k objects.");
        }
        Relation<? extends NumberVector> rel = relation;
        NumberVectorDistance<?> distF = distance;
        DistanceQuery distQ = new QueryBuilder(rel, distF).distanceQuery();
        DBIDs medids = this.chooseInitialMedoids(k, rel.getDBIDs(), distQ);
        double[][] medoids = new double[k][];
        DBIDIter iter = medids.iter();
        for (int i = 0; i < k; ++i) {
            medoids[i] = ((NumberVector)relation.get((DBIDRef)iter)).toArray();
            iter.advance();
        }
        return medoids;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        ArrayModifiableDBIDs medids = DBIDUtil.newArray((int)k);
        DBIDVar bestid = DBIDUtil.newVar();
        WritableDoubleDataStore mindist = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        WritableDoubleDataStore bestd = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        WritableDoubleDataStore tempd = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        double best = Double.POSITIVE_INFINITY;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Choosing initial mean", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double sum = 0.0;
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                double d = distQ.distance((DBIDRef)iter, (DBIDRef)iter2);
                sum += d;
                tempd.putDouble((DBIDRef)iter2, d);
                iter2.advance();
            }
            if (sum < best) {
                best = sum;
                bestid.set((DBIDRef)iter);
                WritableDoubleDataStore temp = mindist;
                mindist = tempd;
                tempd = temp;
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        medids.add((DBIDRef)bestid);
        FiniteProgress prog2 = LOG.isVerbose() ? new FiniteProgress("Choosing initial centers", k, LOG) : null;
        LOG.incrementProcessed((AbstractProgress)prog2);
        for (int i = 1; i < k; ++i) {
            double best2 = Double.POSITIVE_INFINITY;
            bestid.unset();
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                if (!medids.contains((DBIDRef)iter2)) {
                    double sum = 0.0;
                    DBIDIter iter22 = ids.iter();
                    while (iter22.valid()) {
                        double v = MathUtil.min((double)distQ.distance((DBIDRef)iter2, (DBIDRef)iter22), (double)mindist.doubleValue((DBIDRef)iter22));
                        sum += v;
                        tempd.put((DBIDRef)iter22, v);
                        iter22.advance();
                    }
                    if (sum < best2) {
                        best2 = sum;
                        bestid.set((DBIDRef)iter2);
                        WritableDoubleDataStore temp = bestd;
                        bestd = tempd;
                        tempd = temp;
                    }
                }
                iter2.advance();
            }
            if (!bestid.isSet()) {
                throw new AbortException("No medoid found that improves the criterion function?!? Too many infinite distances.");
            }
            medids.add((DBIDRef)bestid);
            WritableDoubleDataStore temp = bestd;
            bestd = mindist;
            mindist = temp;
            LOG.incrementProcessed((AbstractProgress)prog2);
        }
        LOG.ensureCompleted(prog2);
        mindist.destroy();
        bestd.destroy();
        tempd.destroy();
        return medids;
    }

    public static class Par<V>
    implements Parameterizer {
        public BUILD<V> make() {
            return new BUILD();
        }
    }
}

