/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids.initialization;

import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.Parameterizer;
import java.util.Arrays;

@Reference(authors="M. Eug\u00e9nia Captivo", title="Fast primal and dual heuristics for the p-median location problem", booktitle="European Journal of Operational Research 52(1)", url="https://doi.org/10.1016/0377-2217(91)90336-T", bibkey="doi:10.1016/0377-2217(91)90336-T")
public class GreedyG<O>
implements KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(GreedyG.class);

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        DBIDVar bestid = DBIDUtil.newVar();
        WritableDoubleDataStore mindist = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        WritableDoubleDataStore bestd = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        WritableDoubleDataStore tempd = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        WritableIntegerDataStore mina = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)0);
        WritableIntegerDataStore besta = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)0);
        WritableIntegerDataStore tempa = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)0);
        ArrayModifiableDBIDs medids = DBIDUtil.newArray((int)k);
        DBIDArrayMIter miter = medids.iter();
        double[] cost = new double[k];
        double best = Double.POSITIVE_INFINITY;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Choosing initial mean", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double sum = 0.0;
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                double d = distQ.distance((DBIDRef)iter, (DBIDRef)iter2);
                sum += d;
                tempd.putDouble((DBIDRef)iter2, d);
                iter2.advance();
            }
            if (sum < best) {
                best = sum;
                bestid.set((DBIDRef)iter);
                WritableDoubleDataStore swap = mindist;
                mindist = tempd;
                tempd = swap;
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        medids.add((DBIDRef)bestid);
        cost[0] = best;
        ArrayModifiableDBIDs tmpids = DBIDUtil.newArray((int)ids.size());
        boolean[] changed = new boolean[k];
        prog = LOG.isVerbose() ? new FiniteProgress("Choosing initial centers", k, LOG) : null;
        LOG.incrementProcessed((AbstractProgress)prog);
        for (int i = 1; i < k; ++i) {
            double besttd = Double.POSITIVE_INFINITY;
            double besti = 0.0;
            bestid.unset();
            DBIDIter cand = ids.iter();
            while (cand.valid()) {
                if (!medids.contains((DBIDRef)cand) && mindist.doubleValue((DBIDRef)cand) != 0.0) {
                    double td = 0.0;
                    double sum = 0.0;
                    DBIDIter it = ids.iter();
                    while (it.valid()) {
                        double mdist = mindist.doubleValue((DBIDRef)it);
                        double dist = distQ.distance((DBIDRef)cand, (DBIDRef)it);
                        if (dist < mdist) {
                            sum += dist;
                            tempd.put((DBIDRef)it, dist);
                            tempa.put((DBIDRef)it, i);
                        } else {
                            td += mdist;
                            tempd.put((DBIDRef)it, mdist);
                            tempa.put((DBIDRef)it, mina.intValue((DBIDRef)it));
                        }
                        it.advance();
                    }
                    if ((td += sum) < besttd) {
                        besttd = td;
                        besti = sum;
                        bestid.set((DBIDRef)cand);
                        WritableDoubleDataStore swap = bestd;
                        bestd = tempd;
                        tempd = swap;
                        swap = besta;
                        besta = tempa;
                        tempa = swap;
                    }
                }
                cand.advance();
            }
            if (!bestid.isSet()) {
                throw new AbortException("No medoid found that improves the criterion function?!? Too many infinite distances.");
            }
            medids.add((DBIDRef)bestid);
            Arrays.fill(changed, false);
            DBIDIter it = ids.iter();
            while (it.valid()) {
                int p = mina.intValue((DBIDRef)it);
                if (p != besta.intValue((DBIDRef)it)) {
                    changed[p] = true;
                }
                it.advance();
            }
            WritableDoubleDataStore swap = mindist;
            mindist = bestd;
            bestd = swap;
            swap = mina;
            mina = besta;
            besta = swap;
            for (int j = 0; j < i; ++j) {
                if (!changed[j]) continue;
                tmpids.clear();
                DBIDIter it2 = ids.iter();
                while (it2.valid()) {
                    if (mina.intValue((DBIDRef)it2) == j) {
                        tmpids.add((DBIDRef)it2);
                    }
                    it2.advance();
                }
                assert (!tmpids.isEmpty());
                cost[j] = GreedyG.findMedoid((DBIDs)tmpids, distQ, j, miter.seek(j), cost[j], tempd, bestd, mindist);
            }
            cost[i] = besti;
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        mindist.destroy();
        bestd.destroy();
        tempd.destroy();
        return medids;
    }

    public static double findMedoid(DBIDs ids, DistanceQuery<?> distQ, int j, DBIDArrayMIter miter, double bestm, WritableDoubleDataStore temp, WritableDoubleDataStore tempbest, WritableDoubleDataStore mindist) {
        assert (tempbest != temp);
        boolean changed = false;
        DBIDIter cand = ids.iter();
        while (cand.valid()) {
            double sum = 0.0;
            DBIDIter it = ids.iter();
            while (it.valid() && sum < bestm) {
                if (!DBIDUtil.equal((DBIDRef)cand, (DBIDRef)it)) {
                    double dist = distQ.distance((DBIDRef)cand, (DBIDRef)it);
                    sum += dist;
                    temp.put((DBIDRef)it, dist);
                }
                it.advance();
            }
            if (sum < bestm) {
                miter.setDBID((DBIDRef)cand);
                bestm = sum;
                temp.put((DBIDRef)cand, 0.0);
                WritableDoubleDataStore swap = tempbest;
                tempbest = temp;
                temp = swap;
                changed = true;
            }
            cand.advance();
        }
        if (changed) {
            DBIDIter it = ids.iter();
            while (it.valid()) {
                mindist.put((DBIDRef)it, tempbest.doubleValue((DBIDRef)it));
                it.advance();
            }
        }
        return bestm;
    }

    public static class Par<V>
    implements Parameterizer {
        public GreedyG<V> make() {
            return new GreedyG();
        }
    }
}

