/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids.initialization;

import elki.clustering.kmeans.KMeans;
import elki.clustering.kmedoids.KMedoidsClustering;
import elki.clustering.kmedoids.PAM;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.ChainedParameterization;
import elki.utilities.optionhandling.parameterization.ListParameterization;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.Parameter;

@Title(value="K-medoids Initialization by K-medoids")
@Description(value="Initialize k-medoids with k-medoids, usually a less expensive variant.")
public class KMedoidsKMedoidsInitialization<O>
implements KMedoidsInitialization<O> {
    private KMedoidsClustering<O> inner;

    public KMedoidsKMedoidsInitialization(KMedoidsClustering<O> inner) {
        this.inner = inner;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distance) {
        Relation rel = distance.getRelation();
        Clustering<MedoidModel> cl = this.inner.run(rel, k, distance);
        ArrayModifiableDBIDs medoids = DBIDUtil.newArray((int)k);
        for (Cluster<MedoidModel> c : cl.getAllClusters()) {
            medoids.add((DBIDRef)c.getModel().getMedoid());
        }
        return medoids;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID INNER_ID = new OptionID("kmedoids.inner", "Nested k-medoids algorithm for initialization.");
        private KMedoidsClustering<O> inner;

        public void configure(Parameterization config) {
            ObjectParameter innerP = new ObjectParameter(INNER_ID, KMedoidsClustering.class, PAM.class);
            if (config.grab((Parameter)innerP)) {
                ListParameterization innerParameters = new ListParameterization();
                innerParameters.addParameter(KMeans.K_ID, (Object)13);
                innerParameters.addParameter(KMeans.DISTANCE_FUNCTION_ID, SquaredEuclideanDistance.class);
                ChainedParameterization combinedConfig = new ChainedParameterization(new Parameterization[]{innerParameters, config});
                combinedConfig.errorsTo(config);
                this.inner = (KMedoidsClustering)innerP.instantiateClass((Parameterization)combinedConfig);
            }
        }

        public KMedoidsKMedoidsInitialization<O> make() {
            return new KMedoidsKMedoidsInitialization<O>(this.inner);
        }
    }
}

