/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids.initialization;

import elki.clustering.kmeans.initialization.AbstractKMeansInitialization;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.NumberVector;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="Erich Schubert, Peter J. Rousseeuw", title="Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms", booktitle="Proc. 12th Int. Conf. Similarity Search and Applications (SISAP'2019)", url="https://doi.org/10.1007/978-3-030-32047-8_16", bibkey="DBLP:conf/sisap/SchubertR19")
public class LAB<O>
implements KMeansInitialization,
KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(LAB.class);
    private RandomFactory rnd;

    public LAB(RandomFactory rnd) {
        this.rnd = rnd;
    }

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        if (relation.size() < k) {
            throw new AbortException("Database has less than k objects.");
        }
        Relation<? extends NumberVector> rel = relation;
        NumberVectorDistance<?> distF = distance;
        DistanceQuery distQ = new QueryBuilder(rel, distF).distanceQuery();
        DBIDs medids = this.chooseInitialMedoids(k, rel.getDBIDs(), distQ);
        double[][] medoids = new double[k][];
        DBIDIter iter = medids.iter();
        for (int i = 0; i < k; ++i) {
            medoids[i] = ((NumberVector)relation.get((DBIDRef)iter)).toArray();
            iter.advance();
        }
        return medoids;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        ArrayModifiableDBIDs medids = DBIDUtil.newArray((int)k);
        DBIDArrayMIter mi = medids.iter();
        Random rand = this.rnd.getSingleThreadedRandom();
        int ssize = Math.min(ids.size(), 10 + (int)Math.ceil(Math.sqrt(ids.size())));
        WritableDoubleDataStore mindist = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3, (double)Double.NaN);
        WritableDoubleDataStore bestd = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3, (double)Double.NaN);
        WritableDoubleDataStore tempd = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3, (double)Double.NaN);
        ArrayModifiableDBIDs sample = DBIDUtil.newArray((DBIDs)ids);
        DBIDArrayMIter i = sample.iter();
        DBIDArrayMIter j = sample.iter();
        int range = sample.size();
        LAB.shuffle(sample, ssize, range, rand);
        double best = Double.POSITIVE_INFINITY;
        int bestoff = -1;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Choosing initial mean", ssize, LOG) : null;
        i.seek(0);
        while (i.getOffset() < ssize) {
            double sum = 0.0;
            tempd.clear();
            j.seek(0);
            while (j.getOffset() < ssize) {
                double d = distQ.distance((DBIDRef)i, (DBIDRef)j);
                sum += d;
                tempd.putDouble((DBIDRef)j, d);
                j.advance();
            }
            if (sum < best) {
                best = sum;
                bestoff = i.getOffset();
                WritableDoubleDataStore temp = mindist;
                mindist = tempd;
                tempd = temp;
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            i.advance();
        }
        LOG.ensureCompleted(prog);
        medids.add((DBIDRef)i.seek(bestoff));
        sample.swap(bestoff, --range);
        FiniteProgress prog2 = LOG.isVerbose() ? new FiniteProgress("Choosing initial medoids", k, LOG) : null;
        LOG.incrementProcessed((AbstractProgress)prog2);
        while (medids.size() < k) {
            ssize = range < ssize ? range : ssize;
            LAB.shuffle(sample, ssize, range, rand);
            double best2 = Double.POSITIVE_INFINITY;
            int bestoff2 = -1;
            i.seek(0);
            while (i.getOffset() < ssize) {
                if (!medids.contains((DBIDRef)i)) {
                    double sum = 0.0;
                    tempd.clear();
                    j.seek(0);
                    while (j.getOffset() < ssize) {
                        double prev = LAB.getMinDist((DBIDArrayIter)j, distQ, (DBIDArrayIter)mi, mindist);
                        if (prev != 0.0) {
                            double v = MathUtil.min((double)distQ.distance((DBIDRef)i, (DBIDRef)j), (double)prev);
                            sum += v;
                            tempd.put((DBIDRef)j, v);
                        }
                        j.advance();
                    }
                    if (sum < best2) {
                        best2 = sum;
                        bestoff2 = i.getOffset();
                        WritableDoubleDataStore temp = bestd;
                        bestd = tempd;
                        tempd = temp;
                    }
                }
                i.advance();
            }
            if (bestoff2 < 0) {
                throw new AbortException("No medoid found that improves the criterion function?!? Too many infinite distances.");
            }
            medids.add((DBIDRef)i.seek(bestoff2));
            sample.swap(bestoff2, --range);
            WritableDoubleDataStore temp = bestd;
            bestd = mindist;
            mindist = temp;
            LOG.incrementProcessed((AbstractProgress)prog2);
        }
        LOG.ensureCompleted(prog2);
        mindist.destroy();
        bestd.destroy();
        tempd.destroy();
        return medids;
    }

    protected static double getMinDist(DBIDArrayIter j, DistanceQuery<?> distQ, DBIDArrayIter mi, WritableDoubleDataStore mindist) {
        double prev = mindist.doubleValue((DBIDRef)j);
        if (Double.isNaN(prev)) {
            prev = Double.POSITIVE_INFINITY;
            mi.seek(0);
            while (mi.valid()) {
                double d = distQ.distance((DBIDRef)j, (DBIDRef)mi);
                prev = d < prev ? d : prev;
                mi.advance();
            }
            mindist.putDouble((DBIDRef)j, prev);
        }
        return prev;
    }

    private static void shuffle(ArrayModifiableDBIDs ids, int ssize, int end, Random random) {
        ssize = ssize < end ? ssize : end;
        for (int i = 1; i < ssize; ++i) {
            ids.swap(i - 1, i + random.nextInt(end - i));
        }
    }

    public static class Par<V>
    extends AbstractKMeansInitialization.Par {
        public LAB<V> make() {
            return new LAB(this.rnd);
        }
    }
}

