/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids.initialization;

import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.NumberVector;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDHeap;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.Parameterizer;

@Priority(value=-100)
@Reference(authors="H.-S. Park, C.-H. Jun", title="A simple and fast algorithm for K-medoids clustering", booktitle="Expert Systems with Applications 36(2)", url="https://doi.org/10.1016/j.eswa.2008.01.039", bibkey="DBLP:journals/eswa/ParkJ09")
public class ParkJun<O>
implements KMeansInitialization,
KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(ParkJun.class);

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        if (relation.size() < k) {
            throw new AbortException("Database has less than k objects.");
        }
        Relation<? extends NumberVector> rel = relation;
        NumberVectorDistance<?> distF = distance;
        DistanceQuery distQ = new QueryBuilder(rel, distF).distanceQuery();
        DBIDs medids = this.chooseInitialMedoids(k, rel.getDBIDs(), distQ);
        double[][] medoids = new double[k][];
        DBIDIter iter = medids.iter();
        for (int i = 0; i < k; ++i) {
            medoids[i] = ((NumberVector)relation.get((DBIDRef)iter)).toArray();
            iter.advance();
        }
        return medoids;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        WritableDoubleDataStore distsum = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing distance sums", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double sum = 0.0;
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                sum += distQ.distance((DBIDRef)iter, (DBIDRef)iter2);
                iter2.advance();
            }
            distsum.putDouble((DBIDRef)iter, sum);
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        DoubleDBIDHeap knn = DBIDUtil.newMaxHeap((int)k);
        prog = LOG.isVerbose() ? new FiniteProgress("Computing element scores", ids.size(), LOG) : null;
        DBIDIter iter2 = ids.iter();
        while (iter2.valid()) {
            double sum = 0.0;
            DBIDIter iter22 = ids.iter();
            while (iter22.valid()) {
                sum += distQ.distance((DBIDRef)iter2, (DBIDRef)iter22) / distsum.doubleValue((DBIDRef)iter22);
                iter22.advance();
            }
            knn.insert(sum, (DBIDRef)iter2, k);
            LOG.incrementProcessed((AbstractProgress)prog);
            iter2.advance();
        }
        LOG.ensureCompleted(prog);
        distsum.destroy();
        return knn.unorderedIterator().addTo((ModifiableDBIDs)DBIDUtil.newArray((int)k));
    }

    public static class Par<V>
    implements Parameterizer {
        public ParkJun<V> make() {
            return new ParkJun();
        }
    }
}

