/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.meta;

import elki.clustering.ClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.datasource.parser.CSVReaderFormat;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.utilities.documentation.Description;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FileUtil;
import elki.utilities.io.FormatUtil;
import elki.utilities.io.TokenizedReader;
import elki.utilities.io.Tokenizer;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.ArrayList;

@Description(value="Load clustering results from an external file. Each line is expected to consists of one clustering, one integer per point and an (optional) non-numeric label.")
public class ExternalClustering
implements ClusteringAlgorithm<Clustering<? extends Model>> {
    private static final Logging LOG = Logging.getLogger(ExternalClustering.class);
    public static final String COMMENT = "#";
    private URI file;

    public ExternalClustering(URI file) {
        this.file = file;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[0]);
    }

    @Override
    public Clustering<? extends Model> autorun(Database database) {
        Clustering<? extends Model> m = null;
        try (InputStream in = FileUtil.open((URI)this.file, (OpenOption[])new OpenOption[0]);
             TokenizedReader reader = CSVReaderFormat.DEFAULT_FORMAT.makeReader();){
            Tokenizer tokenizer = reader.getTokenizer();
            reader.reset(in);
            IntArrayList assignment = new IntArrayList(database.getRelation((TypeInformation)TypeUtil.DBID, new Object[0]).size());
            ArrayList<String> name = new ArrayList<String>();
            block14: while (reader.nextLineExceptComments()) {
                while (tokenizer.valid()) {
                    try {
                        assignment.add(tokenizer.getIntBase10());
                    }
                    catch (NumberFormatException e) {
                        name.add(tokenizer.getSubstring());
                    }
                    tokenizer.advance();
                }
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest((CharSequence)("Read " + assignment.size() + " assignments and " + name.size() + " labels."));
                }
                for (Relation r : database.getRelations()) {
                    if (r.size() != assignment.size()) continue;
                    this.attachToRelation(r, assignment, name);
                    assignment.clear();
                    name.clear();
                    continue block14;
                }
                throw new AbortException("No relation found to match with clustering of size " + assignment.size());
            }
        }
        catch (IOException e) {
            throw new AbortException("Could not load outlier scores: " + e.getMessage() + " when loading " + this.file, (Throwable)e);
        }
        return m;
    }

    private void attachToRelation(Relation<?> r, IntArrayList assignment, ArrayList<String> name) {
        DBIDs ids = r.getDBIDs();
        if (!(ids instanceof ArrayDBIDs)) {
            throw new AbortException("External clusterings can only be used with static DBIDs.");
        }
        Int2IntOpenHashMap sizes = new Int2IntOpenHashMap();
        IntListIterator it = assignment.iterator();
        while (it.hasNext()) {
            sizes.addTo(it.nextInt(), 1);
        }
        Int2ObjectOpenHashMap cids = new Int2ObjectOpenHashMap(sizes.size());
        ObjectIterator it2 = sizes.int2IntEntrySet().fastIterator();
        while (it2.hasNext()) {
            Int2IntMap.Entry entry = (Int2IntMap.Entry)it2.next();
            cids.put(entry.getIntKey(), (Object)DBIDUtil.newArray((int)entry.getIntValue()));
        }
        it2 = ((ArrayDBIDs)ids).iter();
        for (int i = 0; i < assignment.size(); ++i) {
            ((ArrayModifiableDBIDs)cids.get(assignment.getInt(i))).add((DBIDRef)it2.seek(i));
        }
        Clustering<ClusterModel> result = new Clustering<ClusterModel>();
        Metadata.of(result).setLongName(FormatUtil.format(name, (String)" "));
        ObjectIterator it3 = cids.int2ObjectEntrySet().fastIterator();
        while (it3.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)it3.next();
            boolean noise = entry.getIntKey() < 0;
            result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)entry.getValue(), noise, ClusterModel.CLUSTER));
        }
        Metadata.hierarchyOf(r).addChild(result);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID FILE_ID = new OptionID("externalcluster.file", "The file name containing the (external) cluster vector.");
        private URI file;

        public void configure(Parameterization config) {
            new FileParameter(FILE_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                this.file = x;
            });
        }

        public ExternalClustering make() {
            return new ExternalClustering(this.file);
        }
    }
}

