/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.onedimensional;

import elki.clustering.ClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.VectorUtil;
import elki.data.model.ClusterModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import elki.math.statistics.kernelfunctions.KernelDensityFunction;
import elki.result.Metadata;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Comparator;

public class KNNKernelDensityMinimaClustering
implements ClusteringAlgorithm<Clustering<ClusterModel>> {
    private static final Logging LOG = Logging.getLogger(KNNKernelDensityMinimaClustering.class);
    protected int dim;
    protected KernelDensityFunction kernel;
    protected Mode mode;
    protected int k;
    protected int minwindow;

    public KNNKernelDensityMinimaClustering(int dim, KernelDensityFunction kernel, Mode mode, int k, int minwindow) {
        this.dim = dim;
        this.kernel = kernel;
        this.mode = mode;
        this.k = k;
        this.minwindow = minwindow;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{VectorFieldTypeInformation.typeRequest(NumberVector.class, (int)(this.dim + 1), (int)Integer.MAX_VALUE)});
    }

    public Clustering<ClusterModel> run(Relation<? extends NumberVector> relation) {
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((DBIDs)relation.getDBIDs());
        int size = ids.size();
        ids.sort((Comparator)new VectorUtil.SortDBIDsBySingleDimension(relation, this.dim));
        WritableDoubleDataStore density = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3, (double)0.0);
        DBIDArrayMIter iter = ids.iter();
        DBIDArrayMIter iter2 = ids.iter();
        StepProgress sprog = LOG.isVerbose() ? new StepProgress("Clustering steps", 2) : null;
        LOG.beginStep(sprog, 1, "Kernel density estimation.");
        double[] scratch = new double[2 * this.k];
        iter.seek(0);
        for (int i = 0; i < size; ++i) {
            int j;
            double curv = ((NumberVector)relation.get((DBIDRef)iter)).doubleValue(this.dim);
            int pre = Math.max(i - this.k, 0);
            int prek = i - pre;
            int pos = Math.min(i + this.k, size - 1);
            int posk = pos - i;
            iter2.seek(pre);
            for (j = 0; j < prek; ++j) {
                scratch[j] = curv - ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim);
                iter2.advance();
            }
            assert (iter2.getOffset() == i);
            iter2.advance();
            for (j = 0; j < posk; ++j) {
                scratch[prek + j] = ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim) - curv;
                iter2.advance();
            }
            assert (prek + posk >= this.k);
            double kdist = QuickSelect.quickSelect((double[])scratch, (int)0, (int)(prek + posk), (int)this.k);
            switch (this.mode) {
                case BALLOON: {
                    double dens = 0.0;
                    if (kdist > 0.0) {
                        for (int j2 = 0; j2 < prek + posk; ++j2) {
                            dens += this.kernel.density(scratch[j2] / kdist);
                        }
                    } else {
                        dens = Double.POSITIVE_INFINITY;
                    }
                    assert (iter.getOffset() == i);
                    density.putDouble((DBIDRef)iter, dens);
                    break;
                }
                case SAMPLE: {
                    double delta;
                    if (kdist > 0.0) {
                        int j3;
                        iter2.seek(pre);
                        for (j3 = 0; j3 < prek; ++j3) {
                            delta = curv - ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim);
                            density.putDouble((DBIDRef)iter2, density.doubleValue((DBIDRef)iter2) + this.kernel.density(delta / kdist));
                            iter2.advance();
                        }
                        assert (iter2.getOffset() == i);
                        iter2.advance();
                        for (j3 = 0; j3 < posk; ++j3) {
                            delta = ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim) - curv;
                            density.putDouble((DBIDRef)iter2, density.doubleValue((DBIDRef)iter2) + this.kernel.density(delta / kdist));
                            iter2.advance();
                        }
                    } else {
                        int j4;
                        iter2.seek(pre);
                        for (j4 = 0; j4 < prek; ++j4) {
                            delta = curv - ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim);
                            if (!(delta > 0.0)) {
                                density.putDouble((DBIDRef)iter2, Double.POSITIVE_INFINITY);
                            }
                            iter2.advance();
                        }
                        assert (iter2.getOffset() == i);
                        iter2.advance();
                        for (j4 = 0; j4 < posk; ++j4) {
                            delta = ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim) - curv;
                            if (!(delta > 0.0)) {
                                density.putDouble((DBIDRef)iter2, Double.POSITIVE_INFINITY);
                            }
                            iter2.advance();
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown mode specified.");
                }
            }
            iter.advance();
        }
        LOG.beginStep(sprog, 2, "Local minima detection.");
        Clustering<ClusterModel> clustering = new Clustering<ClusterModel>();
        Metadata.of(clustering).setLongName("One-Dimensional KDE Clustering");
        double[] scratch2 = new double[2 * this.minwindow + 1];
        int begin = 0;
        int halfw = this.minwindow + 1 >> 1;
        iter.seek(0);
        for (int i = 0; i < size; ++i) {
            int m = i % scratch2.length;
            int t = (i - this.minwindow - 1) % scratch2.length;
            scratch2[m] = density.doubleValue((DBIDRef)iter);
            if (i > scratch2.length) {
                double min = Double.POSITIVE_INFINITY;
                for (int j = 0; j < scratch2.length; ++j) {
                    if (j == t || !(scratch2[j] < min)) continue;
                    min = scratch2[j];
                }
                if (scratch2[t] < min) {
                    int end = i - this.minwindow + 1;
                    iter2.seek(end);
                    double curv = ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim);
                    iter2.seek(end - halfw);
                    double left = ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim) - curv;
                    iter2.seek(end + halfw);
                    double right = curv - ((NumberVector)relation.get((DBIDRef)iter2)).doubleValue(this.dim);
                    if (left < right) {
                        ++end;
                    }
                    iter2.seek(begin);
                    ArrayModifiableDBIDs cids = DBIDUtil.newArray((int)(end - begin));
                    for (int j = 0; j < end - begin; ++j) {
                        cids.add((DBIDRef)iter2);
                        iter2.advance();
                    }
                    clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)cids, ClusterModel.CLUSTER));
                    begin = end;
                }
            }
            iter.advance();
        }
        int end = size;
        iter2.seek(begin);
        ArrayModifiableDBIDs cids = DBIDUtil.newArray((int)(end - begin));
        for (int j = 0; j < end - begin; ++j) {
            cids.add((DBIDRef)iter2);
            iter2.advance();
        }
        clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)cids, ClusterModel.CLUSTER));
        LOG.ensureCompleted((FiniteProgress)sprog);
        return clustering;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID DIM_ID = new OptionID("kernelcluster.dim", "Dimension to use for clustering. For one-dimensional data, use 0.");
        public static final OptionID KERNEL_ID = new OptionID("kernelcluster.kernel", "Kernel function for density estimation.");
        public static final OptionID MODE_ID = new OptionID("kernelcluster.mode", "Kernel density estimation mode (baloon estimator vs. sample point estimator).");
        public static final OptionID K_ID = new OptionID("kernelcluster.knn", "Number of nearest neighbors to use for bandwidth estimation.");
        public static final OptionID WINDOW_ID = new OptionID("kernelcluster.window", "Half width of sliding window to find local minima.");
        protected int dim;
        protected KernelDensityFunction kernel;
        protected Mode mode;
        protected int k;
        protected int minwindow;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(DIM_ID, 0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT)).grab(config, x -> {
                this.dim = x;
            });
            new ObjectParameter(KERNEL_ID, KernelDensityFunction.class, EpanechnikovKernelDensityFunction.class).grab(config, x -> {
                this.kernel = x;
            });
            new EnumParameter(MODE_ID, Mode.class, (Enum)Mode.BALLOON).grab(config, x -> {
                this.mode = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ((IntParameter)new IntParameter(WINDOW_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minwindow = x;
            });
        }

        public KNNKernelDensityMinimaClustering make() {
            return new KNNKernelDensityMinimaClustering(this.dim, this.kernel, this.mode, this.k, this.minwindow);
        }
    }

    public static enum Mode {
        BALLOON,
        SAMPLE;

    }
}

