/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.optics;

import elki.Algorithm;
import elki.clustering.optics.ClusterOrder;
import elki.clustering.optics.OPTICSTypeAlgorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, J\u00f6rg Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304187", bibkey="DBLP:conf/sigmod/AnkerstBKS99")
@Alias(value={"OPTICS"})
public abstract class AbstractOPTICS<O>
implements OPTICSTypeAlgorithm {
    protected Distance<? super O> distance;
    protected double epsilon;
    protected int minpts;

    public AbstractOPTICS(Distance<? super O> distance, double epsilon, int minpts) {
        this.distance = distance;
        this.epsilon = epsilon;
        this.minpts = minpts;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public abstract ClusterOrder run(Relation<O> var1);

    @Override
    public int getMinPts() {
        return this.minpts;
    }

    public static abstract class Par<O>
    implements Parameterizer {
        public static final OptionID EPSILON_ID = new OptionID("optics.epsilon", "The maximum radius of the neighborhood to be considered.");
        public static final OptionID MINPTS_ID = new OptionID("optics.minpts", "Threshold for minimum number of points in the epsilon-neighborhood of a point.");
        protected double epsilon = Double.POSITIVE_INFINITY;
        protected int minpts = 0;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)new DoubleParameter(EPSILON_ID).setOptional(true)).grab(config, x -> {
                this.epsilon = x;
            });
            ((IntParameter)new IntParameter(MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minpts = x;
            });
        }
    }
}

