/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.optics;

import elki.data.type.TypeUtil;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.MaterializedRelation;
import elki.result.Metadata;
import elki.result.OrderingResult;

public class ClusterOrder
implements OrderingResult {
    ArrayModifiableDBIDs ids;
    WritableDoubleDataStore reachability;
    WritableDBIDDataStore predecessor;

    public ClusterOrder(DBIDs ids) {
        this.ids = DBIDUtil.newArray((int)ids.size());
        this.reachability = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30, (double)Double.POSITIVE_INFINITY);
        this.predecessor = DataStoreUtil.makeDBIDStorage((DBIDs)ids, (int)2);
        Metadata.hierarchyOf((Object)this).addChild((Object)new MaterializedDoubleRelation("Reachability distance", ids, (DoubleDataStore)this.reachability));
        Metadata.hierarchyOf((Object)this).addChild((Object)new MaterializedRelation("OPTICS predecessor", TypeUtil.DBID, ids, (DataStore)this.predecessor));
    }

    public ClusterOrder(ArrayModifiableDBIDs ids, WritableDoubleDataStore reachability, WritableDBIDDataStore predecessor) {
        this.ids = ids;
        this.reachability = reachability;
        this.predecessor = predecessor;
        Metadata.hierarchyOf((Object)this).addChild((Object)new MaterializedDoubleRelation("Reachability distance", (DBIDs)ids, (DoubleDataStore)reachability));
        if (predecessor != null) {
            Metadata.hierarchyOf((Object)this).addChild((Object)new MaterializedRelation("OPTICS predecessor", TypeUtil.DBID, (DBIDs)ids, (DataStore)predecessor));
        }
    }

    public void add(DBIDRef id, double reach, DBIDRef pre) {
        this.ids.add(id);
        this.reachability.putDouble(id, reach);
        if (pre == null || pre instanceof DBIDVar && !((DBIDVar)pre).isSet()) {
            return;
        }
        this.predecessor.putDBID(id, pre);
    }

    public ArrayDBIDs getDBIDs() {
        return this.ids;
    }

    public DBIDArrayIter iter() {
        return this.ids.iter();
    }

    public ArrayModifiableDBIDs order(DBIDs ids) {
        ArrayModifiableDBIDs res = DBIDUtil.newArray((int)ids.size());
        DBIDArrayMIter it = this.ids.iter();
        while (it.valid()) {
            if (ids.contains((DBIDRef)it)) {
                res.add((DBIDRef)it);
            }
            it.advance();
        }
        return res;
    }

    public int size() {
        return this.ids.size();
    }

    public double getReachability(DBIDRef id) {
        return this.reachability.doubleValue(id);
    }

    public void getPredecessor(DBIDRef id, DBIDVar out) {
        if (this.predecessor == null) {
            out.unset();
            return;
        }
        this.predecessor.assignVar(id, out);
    }
}

