/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.optics;

import elki.clustering.optics.AbstractOPTICS;
import elki.clustering.optics.ClusterOrder;
import elki.clustering.optics.OPTICSHeapEntry;
import elki.clustering.optics.OPTICSTypeAlgorithm;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.index.preprocessed.fastoptics.RandomProjectedNeighborsAndDensities;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.result.Metadata;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.datastructures.heap.UpdatableHeap;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. Schneider, M. Vlachos", title="Fast parameterless density-based clustering via random projections", booktitle="Proc. 22nd ACM Int. Conf. on Information & Knowledge Management (CIKM 2013)", url="https://doi.org/10.1145/2505515.2505590", bibkey="DBLP:conf/cikm/SchneiderV13")
public class FastOPTICS<V extends NumberVector>
implements OPTICSTypeAlgorithm {
    private static final Logging LOG = Logging.getLogger(FastOPTICS.class);
    public static final double UNDEFINED_DISTANCE = (double)-0.1f;
    ClusterOrder order;
    WritableDoubleDataStore reachDist;
    ModifiableDBIDs processed;
    DataStore<? extends DBIDs> neighs;
    DoubleDataStore inverseDensities;
    int minPts;
    RandomProjectedNeighborsAndDensities index;

    public FastOPTICS(int minpts, RandomProjectedNeighborsAndDensities index) {
        this.minPts = minpts;
        this.index = index;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public ClusterOrder run(Relation<V> relation) {
        DBIDs ids = relation.getDBIDs();
        DistanceQuery dq = new QueryBuilder(relation, (Distance)EuclideanDistance.STATIC).distanceQuery();
        this.reachDist = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3, (double)-0.1f);
        this.index.computeSetsBounds(relation, this.minPts, ids);
        this.inverseDensities = this.index.computeAverageDistInSet();
        this.neighs = this.index.getNeighs();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("FastOPTICS clustering", ids.size(), LOG) : null;
        this.processed = DBIDUtil.newHashSet((int)ids.size());
        this.order = new ClusterOrder(ids);
        Metadata.of((Object)this.order).setLongName("FastOPTICS Cluster Order");
        DBIDIter it = ids.iter();
        while (it.valid()) {
            if (!this.processed.contains((DBIDRef)it)) {
                this.expandClusterOrder(DBIDUtil.deref((DBIDRef)it), this.order, dq, prog);
            }
            it.advance();
        }
        this.index.logStatistics();
        LOG.ensureCompleted(prog);
        return this.order;
    }

    protected void expandClusterOrder(DBID ipt, ClusterOrder order, DistanceQuery<V> dq, FiniteProgress prog) {
        UpdatableHeap heap = new UpdatableHeap();
        heap.add((Object)new OPTICSHeapEntry(ipt, null, Double.POSITIVE_INFINITY));
        while (!heap.isEmpty()) {
            OPTICSHeapEntry current = (OPTICSHeapEntry)heap.poll();
            DBID currPt = current.objectID;
            order.add((DBIDRef)currPt, current.reachability, (DBIDRef)current.predecessorID);
            this.processed.add((DBIDRef)currPt);
            double coredist = this.inverseDensities.doubleValue((DBIDRef)currPt);
            DBIDIter it = ((DBIDs)this.neighs.get((DBIDRef)currPt)).iter();
            while (it.valid()) {
                if (!this.processed.contains((DBIDRef)it)) {
                    double nrdist = dq.distance((DBIDRef)currPt, (DBIDRef)it);
                    if (coredist > nrdist) {
                        nrdist = coredist;
                    }
                    if (this.reachDist.doubleValue((DBIDRef)it) == (double)-0.1f || nrdist < this.reachDist.doubleValue((DBIDRef)it)) {
                        this.reachDist.put((DBIDRef)it, nrdist);
                    }
                    heap.add((Object)new OPTICSHeapEntry(DBIDUtil.deref((DBIDRef)it), currPt, nrdist));
                }
                it.advance();
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
    }

    @Override
    public int getMinPts() {
        return this.minPts;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        int minpts;
        RandomProjectedNeighborsAndDensities index;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(AbstractOPTICS.Par.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minpts = x;
            });
            Class clz = ClassGenericsUtil.uglyCastIntoSubclass(RandomProjectedNeighborsAndDensities.class);
            this.index = (RandomProjectedNeighborsAndDensities)config.tryInstantiate(clz);
        }

        public FastOPTICS<V> make() {
            return new FastOPTICS(this.minpts, this.index);
        }
    }
}

