/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.optics;

import elki.clustering.optics.OPTICSTypeAlgorithm;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.ids.QuickSelectDBIDs;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import java.util.Comparator;

public interface GeneralizedOPTICS
extends OPTICSTypeAlgorithm {

    public static abstract class Instance<R>
    implements Comparator<DBIDRef> {
        protected ModifiableDBIDs processedIDs;
        protected ArrayModifiableDBIDs candidates;
        protected WritableDBIDDataStore predecessor;
        protected WritableDoubleDataStore reachability;
        DBIDs ids;
        FiniteProgress progress;

        public Instance(DBIDs ids) {
            this.ids = ids;
            this.processedIDs = DBIDUtil.newHashSet((int)ids.size());
            this.candidates = DBIDUtil.newArray();
            this.predecessor = DataStoreUtil.makeDBIDStorage((DBIDs)ids, (int)2);
            this.reachability = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30, (double)Double.POSITIVE_INFINITY);
            this.progress = this.getLogger().isVerbose() ? new FiniteProgress("OPTICS", ids.size(), this.getLogger()) : null;
        }

        @Override
        public int compare(DBIDRef o1, DBIDRef o2) {
            return Double.compare(this.reachability.doubleValue(o2), this.reachability.doubleValue(o1));
        }

        public R run() {
            Logging LOG = this.getLogger();
            DBIDVar cur = DBIDUtil.newVar();
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                if (!this.processedIDs.contains((DBIDRef)iditer)) {
                    this.initialDBID((DBIDRef)iditer);
                    this.processedIDs.add((DBIDRef)iditer);
                    this.expandDBID((DBIDRef)iditer);
                    LOG.incrementProcessed((AbstractProgress)this.progress);
                    while (!this.candidates.isEmpty()) {
                        int last = this.candidates.size() - 1;
                        QuickSelectDBIDs.quickSelect((ArrayModifiableDBIDs)this.candidates, (Comparator)this, (int)last);
                        this.candidates.assignVar(last, cur);
                        this.candidates.removeSwap(last);
                        this.processedIDs.add((DBIDRef)cur);
                        this.expandDBID((DBIDRef)cur);
                        LOG.incrementProcessed((AbstractProgress)this.progress);
                    }
                }
                iditer.advance();
            }
            LOG.ensureCompleted(this.progress);
            return this.buildResult();
        }

        protected abstract void initialDBID(DBIDRef var1);

        protected abstract void expandDBID(DBIDRef var1);

        protected abstract R buildResult();

        protected abstract Logging getLogger();
    }
}

