/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.optics;

import elki.clustering.optics.AbstractOPTICS;
import elki.clustering.optics.ClusterOrder;
import elki.clustering.optics.OPTICSHeapEntry;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.ModifiableDBIDs;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.result.Metadata;
import elki.utilities.datastructures.heap.UpdatableHeap;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="OPTICS: Density-Based Hierarchical Clustering (implementation using a heap)")
@Reference(authors="Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, J\u00f6rg Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304187", bibkey="DBLP:conf/sigmod/AnkerstBKS99")
public class OPTICSHeap<O>
extends AbstractOPTICS<O> {
    private static final Logging LOG = Logging.getLogger(OPTICSHeap.class);

    public OPTICSHeap(Distance<? super O> distance, double epsilon, int minpts) {
        super(distance, epsilon, minpts);
    }

    @Override
    public ClusterOrder run(Relation<O> relation) {
        return new Instance(relation).run();
    }

    public static class Par<O>
    extends AbstractOPTICS.Par<O> {
        public OPTICSHeap<O> make() {
            return new OPTICSHeap(this.distance, this.epsilon, this.minpts);
        }
    }

    private class Instance {
        private ModifiableDBIDs processedIDs;
        UpdatableHeap<OPTICSHeapEntry> heap;
        ClusterOrder clusterOrder;
        private DBIDs ids;
        FiniteProgress progress;
        RangeSearcher<DBIDRef> rangeQuery;

        public Instance(Relation<O> relation) {
            this.ids = relation.getDBIDs();
            this.processedIDs = DBIDUtil.newHashSet((int)this.ids.size());
            this.clusterOrder = new ClusterOrder(this.ids);
            Metadata.of((Object)this.clusterOrder).setLongName("OPTICS Clusterorder");
            this.progress = LOG.isVerbose() ? new FiniteProgress("OPTICS", this.ids.size(), LOG) : null;
            this.rangeQuery = new QueryBuilder(relation, OPTICSHeap.this.distance).rangeByDBID(OPTICSHeap.this.epsilon);
            this.heap = new UpdatableHeap();
        }

        public ClusterOrder run() {
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                if (!this.processedIDs.contains((DBIDRef)iditer)) {
                    assert (this.heap.isEmpty());
                    this.expandClusterOrder((DBIDRef)iditer);
                }
                iditer.advance();
            }
            LOG.ensureCompleted(this.progress);
            return this.clusterOrder;
        }

        protected void expandClusterOrder(DBIDRef objectID) {
            ModifiableDoubleDBIDList neighbors = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter neighbor = neighbors.iter();
            this.heap.add((Object)new OPTICSHeapEntry(DBIDUtil.deref((DBIDRef)objectID), null, Double.POSITIVE_INFINITY));
            while (!this.heap.isEmpty()) {
                OPTICSHeapEntry current = (OPTICSHeapEntry)this.heap.poll();
                this.clusterOrder.add((DBIDRef)current.objectID, current.reachability, (DBIDRef)current.predecessorID);
                this.processedIDs.add((DBIDRef)current.objectID);
                this.rangeQuery.getRange((Object)current.objectID, OPTICSHeap.this.epsilon, neighbors.clear());
                if (neighbors.size() >= OPTICSHeap.this.minpts) {
                    neighbors.sort();
                    double coreDistance = neighbor.seek(OPTICSHeap.this.minpts - 1).doubleValue();
                    neighbor.seek(0);
                    while (neighbor.valid()) {
                        if (!this.processedIDs.contains((DBIDRef)neighbor)) {
                            double reachability = MathUtil.max((double)neighbor.doubleValue(), (double)coreDistance);
                            this.heap.add((Object)new OPTICSHeapEntry(DBIDUtil.deref((DBIDRef)neighbor), current.objectID, reachability));
                        }
                        neighbor.advance();
                    }
                }
                LOG.incrementProcessed((AbstractProgress)this.progress);
            }
        }
    }
}

