/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.optics;

import elki.clustering.optics.AbstractOPTICS;
import elki.clustering.optics.ClusterOrder;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.ModifiableDBIDs;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="OPTICS: Density-Based Hierarchical Clustering (implementation using a list)")
@Reference(authors="Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, J\u00f6rg Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304187", bibkey="DBLP:conf/sigmod/AnkerstBKS99")
public class OPTICSList<O>
extends AbstractOPTICS<O> {
    private static final Logging LOG = Logging.getLogger(OPTICSList.class);

    public OPTICSList(Distance<? super O> distance, double epsilon, int minpts) {
        super(distance, epsilon, minpts);
    }

    @Override
    public ClusterOrder run(Relation<O> relation) {
        return new Instance(relation).run();
    }

    public static class Par<O>
    extends AbstractOPTICS.Par<O> {
        public OPTICSList<O> make() {
            return new OPTICSList(this.distance, this.epsilon, this.minpts);
        }
    }

    private class Instance {
        ModifiableDBIDs processedIDs;
        ArrayModifiableDBIDs candidates;
        WritableDBIDDataStore predecessor;
        WritableDoubleDataStore reachability;
        ClusterOrder clusterOrder;
        DBIDs ids;
        FiniteProgress progress;
        RangeSearcher<DBIDRef> rangeQuery;

        public Instance(Relation<O> relation) {
            this.ids = relation.getDBIDs();
            this.processedIDs = DBIDUtil.newHashSet((int)this.ids.size());
            this.candidates = DBIDUtil.newArray();
            this.predecessor = DataStoreUtil.makeDBIDStorage((DBIDs)this.ids, (int)2);
            this.reachability = DataStoreUtil.makeDoubleStorage((DBIDs)this.ids, (int)30, (double)Double.POSITIVE_INFINITY);
            this.clusterOrder = new ClusterOrder(this.ids);
            Metadata.of((Object)this.clusterOrder).setLongName("OPTICS Clusterorder");
            this.progress = LOG.isVerbose() ? new FiniteProgress("OPTICS", this.ids.size(), LOG) : null;
            this.rangeQuery = new QueryBuilder(relation, OPTICSList.this.distance).rangeByDBID(OPTICSList.this.epsilon);
        }

        public ClusterOrder run() {
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                if (!this.processedIDs.contains((DBIDRef)iditer)) {
                    this.expandClusterOrder((DBIDRef)iditer);
                }
                iditer.advance();
            }
            LOG.ensureCompleted(this.progress);
            return this.clusterOrder;
        }

        protected void expandClusterOrder(DBIDRef objectID) {
            ModifiableDoubleDBIDList neighbors = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter neighbor = neighbors.iter();
            this.candidates.add(objectID);
            this.predecessor.putDBID(objectID, objectID);
            this.reachability.put(objectID, Double.POSITIVE_INFINITY);
            DBIDArrayMIter it = this.candidates.iter();
            DBIDVar cur = DBIDUtil.newVar();
            DBIDVar prev = DBIDUtil.newVar();
            while (!this.candidates.isEmpty()) {
                this.findBest(this.candidates, it, cur);
                this.processedIDs.add((DBIDRef)cur);
                this.clusterOrder.add((DBIDRef)cur, this.reachability.doubleValue((DBIDRef)cur), (DBIDRef)this.predecessor.assignVar((DBIDRef)cur, prev));
                LOG.incrementProcessed((AbstractProgress)this.progress);
                this.rangeQuery.getRange((Object)cur, OPTICSList.this.epsilon, neighbors.clear());
                if (neighbors.size() < OPTICSList.this.minpts) continue;
                neighbors.sort();
                double coreDistance = neighbor.seek(OPTICSList.this.minpts - 1).doubleValue();
                neighbor.seek(0);
                while (neighbor.valid()) {
                    double prevreach;
                    double reach;
                    if (!this.processedIDs.contains((DBIDRef)neighbor) && (reach = MathUtil.max((double)neighbor.doubleValue(), (double)coreDistance)) < (prevreach = this.reachability.doubleValue((DBIDRef)neighbor))) {
                        this.reachability.put((DBIDRef)neighbor, reach);
                        this.predecessor.putDBID((DBIDRef)neighbor, (DBIDRef)cur);
                        if (prevreach == Double.POSITIVE_INFINITY) {
                            this.candidates.add((DBIDRef)neighbor);
                        }
                    }
                    neighbor.advance();
                }
            }
        }

        public void findBest(ArrayModifiableDBIDs candidates, DBIDArrayMIter it, DBIDVar out) {
            assert (candidates.size() > 0);
            int bestidx = 0;
            double min = this.reachability.doubleValue((DBIDRef)out.set((DBIDRef)it.seek(0)));
            it.advance();
            while (it.valid()) {
                double reach = this.reachability.doubleValue((DBIDRef)it);
                if (reach < min || reach == min && DBIDUtil.compare((DBIDRef)it, (DBIDRef)out) < 0) {
                    min = reach;
                    out.set((DBIDRef)it);
                    bestidx = it.getOffset();
                }
                it.advance();
            }
            it.seek(bestidx).remove();
        }
    }
}

