/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.optics;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.optics.ClusterOrder;
import elki.clustering.optics.OPTICSHeap;
import elki.clustering.optics.OPTICSTypeAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.OPTICSModel;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.result.IterableResult;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassParameter;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@Title(value="OPTICS Xi Cluster Extraction")
@References(value={@Reference(authors="Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, J\u00f6rg Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304187", bibkey="DBLP:conf/sigmod/AnkerstBKS99"), @Reference(authors="Erich Schubert, Michael Gertz", title="Improving the Cluster Structure Extracted from OPTICS Plots", booktitle="Proc. Lernen, Wissen, Daten, Analysen (LWDA 2018)", url="http://ceur-ws.org/Vol-2191/paper37.pdf", bibkey="DBLP:conf/lwa/SchubertG18")})
@Priority(value=200)
public class OPTICSXi
implements ClusteringAlgorithm<Clustering<OPTICSModel>> {
    private static final Logging LOG = Logging.getLogger(OPTICSXi.class);
    OPTICSTypeAlgorithm optics;
    double xi;
    boolean nocorrect;
    boolean keepsteep;

    public OPTICSXi(OPTICSTypeAlgorithm optics, double xi, boolean nocorrect, boolean keepsteep) {
        this.optics = optics;
        this.xi = xi;
        this.nocorrect = nocorrect;
        this.keepsteep = keepsteep;
    }

    public OPTICSXi(OPTICSTypeAlgorithm optics, double xi) {
        this(optics, xi, false, false);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.optics.getInputTypeRestriction();
    }

    @Override
    public Clustering<OPTICSModel> autorun(Database database) {
        return this.run(this.optics.autorun(database));
    }

    public Clustering<OPTICSModel> run(ClusterOrder clusterOrder) {
        return this.extractClusters(clusterOrder, 1.0 - this.xi, this.optics.getMinPts());
    }

    private Clustering<OPTICSModel> extractClusters(ClusterOrder clusterOrderResult, double ixi, int minpts) {
        ArrayModifiableDBIDs clusterOrder = clusterOrderResult.ids;
        DBIDArrayIter iter = clusterOrder.iter();
        WritableDoubleDataStore reach = clusterOrderResult.reachability;
        ClusterHierarchyBuilder builder = new ClusterHierarchyBuilder((DBIDs)clusterOrder);
        double mib = 0.0;
        ArrayList<SteepArea> salist = this.keepsteep ? new ArrayList<SteepArea>() : null;
        ArrayList<SteepDownArea> sdaset = new ArrayList<SteepDownArea>();
        SteepScanPosition scan = new SteepScanPosition(clusterOrderResult);
        while (scan.hasNext()) {
            mib = MathUtil.max((double)mib, (double)scan.getReachability());
            if (scan.steepDown(ixi)) {
                OPTICSXi.updateFilterSDASet(mib, sdaset, ixi);
                double startval = scan.getReachability();
                mib = 0.0;
                int startsteep = scan.index;
                int endsteep = scan.index;
                scan.next();
                while (scan.hasNext()) {
                    if (scan.steepDown(ixi)) {
                        endsteep = scan.index;
                    } else if (!scan.steepDown(1.0) || scan.index - endsteep > minpts) break;
                    scan.next();
                }
                SteepDownArea sda = new SteepDownArea(startsteep, endsteep, startval, 0.0);
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest((CharSequence)("New steep down area: " + sda.toString()));
                }
                sdaset.add(sda);
                if (salist == null) continue;
                salist.add(sda);
                continue;
            }
            if (scan.steepUp(ixi)) {
                OPTICSXi.updateFilterSDASet(mib, sdaset, ixi);
                int startsteep = scan.index;
                int endsteep = scan.index;
                mib = scan.getReachability();
                double esuccr = scan.getNextReachability();
                while (!Double.isInfinite(esuccr) && scan.hasNext()) {
                    scan.next();
                    if (scan.steepUp(ixi)) {
                        endsteep = scan.index;
                        mib = scan.getReachability();
                        esuccr = scan.getNextReachability();
                        continue;
                    }
                    if (scan.steepUp(1.0) && scan.index - endsteep <= minpts) continue;
                }
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest((CharSequence)("New steep up area: " + startsteep + "-" + endsteep + " max:" + esuccr));
                }
                if (salist != null) {
                    salist.add(new SteepUpArea(startsteep, endsteep, esuccr));
                }
                if (Double.isInfinite(esuccr)) {
                    scan.next();
                }
                ListIterator sdaiter = sdaset.listIterator(sdaset.size());
                while (sdaiter.hasPrevious()) {
                    double eU;
                    SteepDownArea sda = (SteepDownArea)sdaiter.previous();
                    int cstart = sda.getStartIndex();
                    int cend = endsteep;
                    cend = this.nocorrect ? cend : OPTICSXi.predecessorFilter(clusterOrderResult, cstart, cend, iter);
                    double d = eU = cend + 1 < clusterOrderResult.size() ? reach.doubleValue((DBIDRef)iter.seek(cend + 1)) : Double.POSITIVE_INFINITY;
                    if (LOG.isDebuggingFinest()) {
                        LOG.debugFinest((CharSequence)("Comparing: eU=" + eU + " SDA: " + sda.toString()));
                    }
                    if (sda.mib > MathUtil.min((double)sda.maximum, (double)eU) * ixi) {
                        if (!LOG.isDebuggingFinest()) continue;
                        LOG.debugFinest((CharSequence)("mib = " + sda.mib + " > min(sD, eU) * ixi  = " + MathUtil.min((double)sda.maximum, (double)eU) * ixi));
                        continue;
                    }
                    if (sda.maximum * ixi >= eU) {
                        while (cstart < cend && reach.doubleValue((DBIDRef)iter.seek(cstart + 1)) * ixi > eU) {
                            ++cstart;
                        }
                    } else if (eU * ixi >= sda.maximum) {
                        while (cend > cstart && reach.doubleValue((DBIDRef)iter.seek(cend)) * ixi > sda.maximum) {
                            --cend;
                        }
                    }
                    int n = cend = this.nocorrect ? cend : OPTICSXi.predecessorFilter(clusterOrderResult, cstart, cend, iter);
                    if (cend - cstart + 1 < minpts) {
                        if (!LOG.isDebuggingFinest()) continue;
                        LOG.debugFinest((CharSequence)"MinPts not satisfied.");
                        continue;
                    }
                    builder.addCluster(iter, cstart, cend);
                }
                continue;
            }
            scan.next();
        }
        Clustering clustering = builder.build(clusterOrderResult, iter);
        Metadata.hierarchyOf((Object)clustering).addChild((Object)clusterOrderResult);
        if (salist != null) {
            Metadata.hierarchyOf((Object)clusterOrderResult).addChild((Object)new SteepAreaResult(salist));
        }
        return clustering;
    }

    private static int predecessorFilter(ClusterOrder clusterOrderResult, int cstart, int cend, DBIDArrayIter tmp) {
        if (cend == clusterOrderResult.size()) {
            return cend;
        }
        double startval = clusterOrderResult.reachability.doubleValue((DBIDRef)tmp.seek(cstart));
        DBIDVar tmp2 = null;
        block0: while (cend > cstart) {
            tmp.seek(cend);
            if (clusterOrderResult.reachability.doubleValue((DBIDRef)tmp) < startval) break;
            tmp2 = tmp2 != null ? tmp2 : DBIDUtil.newVar();
            clusterOrderResult.predecessor.assignVar((DBIDRef)tmp, tmp2);
            for (int i = cstart; i < cend; ++i) {
                if (DBIDUtil.equal((DBIDRef)tmp2, (DBIDRef)tmp.seek(i))) break block0;
            }
            if (LOG.isDebuggingFinest()) {
                LOG.debugFinest((CharSequence)"Pruned one point by predecessor rule.");
            }
            --cend;
        }
        return cend;
    }

    private static void updateFilterSDASet(double mib, List<SteepDownArea> sdaset, double ixi) {
        Iterator<SteepDownArea> iter = sdaset.iterator();
        while (iter.hasNext()) {
            SteepDownArea sda = iter.next();
            if (sda.maximum * ixi <= mib) {
                iter.remove();
                continue;
            }
            if (!(mib > sda.mib)) continue;
            sda.mib = mib;
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID XIALG_ID = new OptionID("opticsxi.algorithm", "The actual OPTICS-type algorithm to use.");
        public static final OptionID XI_ID = new OptionID("opticsxi.xi", "Threshold for the steepness requirement.");
        public static final OptionID NOCORRECT_ID = new OptionID("opticsxi.nocorrect", "Disable the predecessor correction.");
        public static final OptionID KEEPSTEEP_ID = new OptionID("opticsxi.keepsteep", "Keep the steep up/down areas of the plot.");
        protected OPTICSTypeAlgorithm optics;
        protected double xi = 0.0;
        protected boolean nocorrect = false;
        protected boolean keepsteep = false;

        public void configure(Parameterization config) {
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(XI_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE)).grab(config, x -> {
                this.xi = x;
            });
            new ClassParameter(XIALG_ID, OPTICSTypeAlgorithm.class, OPTICSHeap.class).grab(config, x -> {
                this.optics = x;
            });
            new Flag(NOCORRECT_ID).grab(config, x -> {
                this.nocorrect = x;
            });
            new Flag(KEEPSTEEP_ID).grab(config, x -> {
                this.keepsteep = x;
            });
        }

        public OPTICSXi make() {
            return new OPTICSXi(this.optics, this.xi, this.nocorrect, this.keepsteep);
        }
    }

    public static class SteepAreaResult
    implements IterableResult<SteepArea> {
        Collection<SteepArea> areas;

        public SteepAreaResult(Collection<SteepArea> areas) {
            this.areas = areas;
        }

        public Iterator<SteepArea> iterator() {
            return this.areas.iterator();
        }
    }

    public static class SteepUpArea
    extends SteepArea {
        public SteepUpArea(int startindex, int endindex, double endDouble) {
            super(startindex, endindex, endDouble);
        }

        public String toString() {
            return "SteepUpArea(" + this.getStartIndex() + " - " + this.getEndIndex() + ", max=" + this.maximum + ")";
        }
    }

    public static class SteepDownArea
    extends SteepArea {
        double mib;

        public SteepDownArea(int startindex, int endindex, double startDouble, double mib) {
            super(startindex, endindex, startDouble);
            this.mib = mib;
        }

        public String toString() {
            return "SteepDownArea(" + this.getStartIndex() + " - " + this.getEndIndex() + ", max=" + this.maximum + ", mib=" + this.mib + ")";
        }
    }

    public static abstract class SteepArea {
        int startindex;
        int endindex;
        double maximum;

        public SteepArea(int startindex, int endindex, double maximum) {
            this.startindex = startindex;
            this.endindex = endindex;
            this.maximum = maximum;
        }

        public int getStartIndex() {
            return this.startindex;
        }

        public int getEndIndex() {
            return this.endindex;
        }
    }

    private static class SteepScanPosition {
        ClusterOrder co;
        int index;
        private DBIDArrayIter cur;
        private DBIDArrayIter next;
        private FiniteProgress prog;

        public SteepScanPosition(ClusterOrder co) {
            this.co = co;
            this.index = 0;
            this.cur = co.ids.iter();
            this.next = co.ids.iter();
            if (this.next.valid()) {
                this.next.advance();
            }
            this.prog = LOG.isVerbose() ? new FiniteProgress("OPTICS Xi cluster extraction", co.size(), LOG) : null;
        }

        public void next() {
            ++this.index;
            this.cur.advance();
            this.next.advance();
            LOG.incrementProcessed((AbstractProgress)this.prog);
        }

        public boolean hasNext() {
            if (this.index == this.co.size()) {
                LOG.ensureCompleted(this.prog);
            }
            return this.index < this.co.size();
        }

        public boolean steepUp(double ixi) {
            double creach = this.co.reachability.doubleValue((DBIDRef)this.cur);
            return creach < Double.POSITIVE_INFINITY && (!this.next.valid() || creach <= this.co.reachability.doubleValue((DBIDRef)this.next) * ixi);
        }

        public boolean steepDown(double ixi) {
            double nreach = this.getNextReachability();
            return nreach < Double.POSITIVE_INFINITY && nreach <= this.co.reachability.doubleValue((DBIDRef)this.cur) * ixi;
        }

        public double getReachability() {
            return this.co.reachability.doubleValue((DBIDRef)this.cur);
        }

        public double getNextReachability() {
            return this.next.valid() ? this.co.reachability.doubleValue((DBIDRef)this.next) : Double.POSITIVE_INFINITY;
        }
    }

    private static class ClusterHierarchyBuilder {
        Clustering<OPTICSModel> clustering = new Clustering();
        HashSet<Cluster<OPTICSModel>> curclusters = new HashSet();
        HashSetModifiableDBIDs unclaimedids;

        public ClusterHierarchyBuilder(DBIDs ids) {
            this.unclaimedids = DBIDUtil.newHashSet((DBIDs)ids);
        }

        private void addCluster(DBIDArrayIter tmp, int cstart, int cend) {
            ArrayModifiableDBIDs dbids = DBIDUtil.newArray();
            for (int idx = cstart; idx <= cend; ++idx) {
                tmp.seek(idx);
                if (!this.unclaimedids.remove((DBIDRef)tmp)) continue;
                dbids.add((DBIDRef)tmp);
            }
            if (LOG.isDebuggingFine()) {
                LOG.debugFine((CharSequence)("Found cluster with " + dbids.size() + " new objects, length " + (cend - cstart + 1)));
            }
            OPTICSModel model = new OPTICSModel(cstart, cend);
            Cluster<OPTICSModel> cluster = new Cluster<OPTICSModel>("Cluster_" + cstart + "_" + cend, (DBIDs)dbids, model);
            Iterator<Cluster<OPTICSModel>> iter = this.curclusters.iterator();
            while (iter.hasNext()) {
                Cluster<OPTICSModel> clus = iter.next();
                OPTICSModel omodel = clus.getModel();
                if (model.getStartIndex() > omodel.getStartIndex() || omodel.getEndIndex() > model.getEndIndex()) continue;
                this.clustering.addChildCluster(cluster, clus);
                iter.remove();
            }
            this.curclusters.add(cluster);
        }

        private Clustering<OPTICSModel> build(ClusterOrder clusterOrder, DBIDArrayIter iter) {
            if (!this.unclaimedids.isEmpty()) {
                boolean noise = Double.isInfinite(clusterOrder.getReachability((DBIDRef)iter.seek(clusterOrder.size() - 1)));
                Cluster<OPTICSModel> allcluster = new Cluster<OPTICSModel>(noise ? "Noise" : "Cluster", (DBIDs)this.unclaimedids, noise, new OPTICSModel(0, clusterOrder.size() - 1));
                for (Cluster<OPTICSModel> cluster : this.curclusters) {
                    this.clustering.addChildCluster(allcluster, cluster);
                }
                this.clustering.addToplevelCluster(allcluster);
            } else {
                for (Cluster<OPTICSModel> cluster : this.curclusters) {
                    this.clustering.addToplevelCluster(cluster);
                }
            }
            Metadata.of(this.clustering).setLongName("OPTICS Xi-Clusters");
            return this.clustering;
        }
    }
}

