/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.silhouette;

import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.clustering.silhouette.FastMSC;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.linearalgebra.VMath;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="Lars Lenssen and Erich Schubert", title="Clustering by Direct Optimization of the Medoid Silhouette", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2022", url="https://doi.org/10.1007/978-3-031-17849-8_15", bibkey="DBLP:conf/sisap/LenssenS22")
@Priority(value=200)
public class FasterMSC<O>
extends FastMSC<O> {
    private static final Logging LOG = Logging.getLogger(FasterMSC.class);

    public FasterMSC(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DoubleDataStore silhouettes;
        double sil;
        Object instance;
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        if (k == 2) {
            instance = new Instance2(distQ, ids, assignment);
            sil = ((Instance2)instance).run(medoids, this.maxiter);
            silhouettes = ((FastMSC.Instance2)instance).silhouetteScores();
        } else {
            instance = new Instance(distQ, ids, assignment);
            sil = ((Instance)instance).run(medoids, this.maxiter);
            silhouettes = ((FastMSC.Instance)instance).silhouetteScores();
        }
        this.getLogger().statistics((Statistic)optd.end());
        Clustering<MedoidModel> res = FasterMSC.wrapResult(ids, assignment, medoids, "FasterMSC Clustering");
        Metadata.hierarchyOf(res).addChild((Object)new MaterializedDoubleRelation("Silhouette scores", ids, silhouettes));
        EvaluationResult ev = EvaluationResult.findOrCreate(res, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Medoid Silhouette", sil, -1.0, 1.0, 0.0, false);
        return res;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    extends FastMSC.Par<O> {
        @Override
        public FasterMSC<O> make() {
            return new FasterMSC(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected class Instance
    extends FastMSC.Instance {
        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            DBIDIter j;
            int k = medoids.size();
            double sil = this.assignToNearestCluster((ArrayDBIDs)medoids);
            DBIDArrayMIter m = medoids.iter();
            String key = this.getClass().getName().replace("$Instance", "");
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + 0 + ".medoid-silhouette", sil));
            }
            double[] losses = new double[k];
            double[] scratch = new double[k];
            this.updateRemovalLoss(losses);
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("FastMSC iteration", LOG) : null;
            DBIDVar lastswap = DBIDUtil.newVar();
            int iteration = 0;
            int prevswaps = 0;
            int swaps = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                j = this.ids.iter();
                while (j.valid() && !DBIDUtil.equal((DBIDRef)j, (DBIDRef)lastswap)) {
                    if (!DBIDUtil.equal((DBIDRef)m.seek(((FastMSC.Record)this.assignment.get((DBIDRef)j)).m1), (DBIDRef)j)) {
                        System.arraycopy(losses, 0, scratch, 0, k);
                        double acc = this.findBestSwap((DBIDRef)j, scratch);
                        int b = VMath.argmax((double[])scratch);
                        double l = scratch[b] + acc;
                        if (l > 0.0) {
                            ++swaps;
                            medoids.set(b, (DBIDRef)j);
                            sil = this.doSwap((ArrayDBIDs)medoids, b, (DBIDRef)j);
                            this.updateRemovalLoss(losses);
                            if (LOG.isStatistics()) {
                                LOG.statistics((Statistic)new DoubleStatistic(key + ".swap-" + swaps + ".medoid-silhouette", sil));
                            }
                            lastswap.set((DBIDRef)j);
                        }
                    }
                    j.advance();
                }
                if (LOG.isStatistics()) {
                    LOG.statistics((Statistic)new LongStatistic(key + ".iteration-" + iteration + ".swaps", (long)(swaps - prevswaps)));
                }
                if (prevswaps == swaps) break;
                prevswaps = swaps;
                if (!LOG.isStatistics()) continue;
                LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + iteration + ".medoid-silhouette", sil));
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(key + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new DoubleStatistic(key + ".final-medoid-silhouette", sil));
            }
            j = this.ids.iter();
            while (j.valid()) {
                this.output.putInt((DBIDRef)j, ((FastMSC.Record)this.assignment.get((DBIDRef)j)).m1);
                j.advance();
            }
            return sil;
        }
    }

    protected class Instance2
    extends FastMSC.Instance2 {
        public Instance2(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int k = medoids.size();
            assert (k == 2);
            double sil = this.assignToNearestCluster((ArrayDBIDs)medoids);
            DBIDArrayMIter m = medoids.iter();
            String key = this.getClass().getName().replace("$Instance", "");
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + 0 + ".medoid-silhouette", sil));
            }
            double[] scratch = new double[k];
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("FastMSC iteration", LOG) : null;
            DBIDVar lastswap = DBIDUtil.newVar();
            int iteration = 0;
            int prevswaps = 0;
            int swaps = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                DBIDIter j = this.ids.iter();
                while (j.valid() && !DBIDUtil.equal((DBIDRef)j, (DBIDRef)lastswap)) {
                    if (!DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)j)), (DBIDRef)j)) {
                        Arrays.fill(scratch, 0.0);
                        this.findBestSwap((DBIDRef)j, scratch);
                        int b = scratch[0] > scratch[1] ? 0 : 1;
                        double l = scratch[b];
                        if (l > sil) {
                            medoids.set(b, (DBIDRef)j);
                            sil = this.doSwap((ArrayDBIDs)medoids, b, (DBIDRef)j);
                            ++swaps;
                            if (LOG.isStatistics()) {
                                LOG.statistics((Statistic)new DoubleStatistic(key + ".swap-" + swaps + ".medoid-silhouette", sil));
                            }
                            lastswap.set((DBIDRef)j);
                        }
                    }
                    j.advance();
                }
                if (LOG.isStatistics()) {
                    LOG.statistics((Statistic)new LongStatistic(key + ".iteration-" + iteration + ".swaps", (long)(swaps - prevswaps)));
                }
                if (prevswaps == swaps) break;
                prevswaps = swaps;
                if (!LOG.isStatistics()) continue;
                LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + iteration + ".medoid-silhouette", sil));
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(key + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new DoubleStatistic(key + ".final-medoid-silhouette", sil));
            }
            return sil;
        }
    }
}

