/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.silhouette;

import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.clustering.silhouette.PAMSIL;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;

@References(value={@Reference(authors="M. Van der Laan, K. Pollard, J. Bryan", title="A new partitioning around medoids algorithm", booktitle="Journal of Statistical Computation and Simulation 73(8)", url="https://doi.org/10.1080/0094965031000136012", bibkey="doi:10.1080/0094965031000136012"), @Reference(authors="Lars Lenssen and Erich Schubert", title="Clustering by Direct Optimization of the Medoid Silhouette", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2022", url="https://doi.org/10.1007/978-3-031-17849-8_15", bibkey="DBLP:conf/sisap/LenssenS22")})
public class PAMMEDSIL<O>
extends PAMSIL<O> {
    private static final Logging LOG = Logging.getLogger(PAMMEDSIL.class);

    public PAMMEDSIL(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        Instance instance = new Instance(distQ, ids, assignment);
        double sil = instance.run(medoids, this.maxiter);
        DoubleDataStore silhouettes = instance.silhouetteScores();
        this.getLogger().statistics((Statistic)optd.end());
        Clustering<MedoidModel> res = PAMMEDSIL.wrapResult(ids, assignment, medoids, "PAMMEDSIL Clustering");
        Metadata.hierarchyOf(res).addChild((Object)new MaterializedDoubleRelation("Silhouette scores", ids, silhouettes));
        EvaluationResult ev = EvaluationResult.findOrCreate(res, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Medoid Silhouette", sil, -1.0, 1.0, 0.0, false);
        return res;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    extends PAMSIL.Par<O> {
        @Override
        public PAMMEDSIL<O> make() {
            return new PAMMEDSIL(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends PAMSIL.Instance {
        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int k = medoids.size();
            this.assignToNearestCluster((ArrayDBIDs)medoids);
            DBIDArrayMIter m = medoids.iter();
            double sil = this.medoidsilhouette((IntegerDataStore)this.assignment, (DBIDArrayIter)m);
            String key = this.getClass().getName().replace("$Instance", "");
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + 0 + ".medoid-silhouette", sil));
            }
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAMMEDSIL iteration", LOG) : null;
            DBIDVar bestid = DBIDUtil.newVar();
            int iteration = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                double best = sil;
                int bestcluster = -1;
                DBIDIter h = this.ids.iter();
                while (h.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)h)), (DBIDRef)h)) {
                        for (int pi = 0; pi < k; ++pi) {
                            this.reassignToNearestCluster((IntegerDataStore)this.assignment, this.scratch, (ArrayDBIDs)medoids, pi, (DBIDRef)h);
                            double csil = this.medoidsilhouette((IntegerDataStore)this.scratch, (DBIDArrayIter)m, pi, (DBIDRef)h);
                            if (!(csil > best)) continue;
                            best = csil;
                            bestid.set((DBIDRef)h);
                            bestcluster = pi;
                        }
                    }
                    h.advance();
                }
                if (best <= sil) break;
                if (LOG.isStatistics()) {
                    LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + iteration + ".medoid-silhouette", best));
                }
                sil = best;
                this.reassignToNearestCluster((IntegerDataStore)this.assignment, this.assignment, (ArrayDBIDs)medoids, bestcluster, (DBIDRef)bestid);
                medoids.set(bestcluster, (DBIDRef)bestid);
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(key + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new DoubleStatistic(key + ".final-medoid-silhouette", sil));
            }
            return sil;
        }

        protected double medoidsilhouette(IntegerDataStore assignment, DBIDArrayIter m) {
            double silsum = 0.0;
            DBIDIter x = this.ids.iter();
            while (x.valid()) {
                int c = assignment.intValue((DBIDRef)x);
                double a = DBIDUtil.equal((DBIDRef)x, (DBIDRef)m.seek(c)) ? 0.0 : this.distQ.distance((DBIDRef)x, (DBIDRef)m);
                double b = Double.POSITIVE_INFINITY;
                m.seek(0);
                while (m.valid()) {
                    if (m.getOffset() != c) {
                        double d = this.distQ.distance((DBIDRef)x, (DBIDRef)m);
                        b = d < b ? d : b;
                    }
                    m.advance();
                }
                assert (a <= b) : "Not assigned to nearest";
                silsum += b > 0.0 ? a / b : 0.0;
                x.advance();
            }
            return 1.0 - silsum / (double)this.ids.size();
        }

        protected double medoidsilhouette(IntegerDataStore assignment, DBIDArrayIter m, int hoff, DBIDRef h) {
            double silsum = 0.0;
            DBIDIter x = this.ids.iter();
            while (x.valid()) {
                int c = assignment.intValue((DBIDRef)x);
                DBIDRef mc = c == hoff ? h : m.seek(c);
                double a = DBIDUtil.equal((DBIDRef)x, (DBIDRef)mc) ? 0.0 : this.distQ.distance((DBIDRef)x, mc);
                double b = Double.POSITIVE_INFINITY;
                m.seek(0);
                while (m.valid()) {
                    if (m.getOffset() != c) {
                        double d = this.distQ.distance((DBIDRef)x, (DBIDRef)(m.getOffset() == hoff ? h : m));
                        b = d < b ? d : b;
                    }
                    m.advance();
                }
                assert (a <= b) : "Not assigned to nearest";
                double s = b > 0.0 ? a / b : 0.0;
                this.silhouettes.putDouble((DBIDRef)x, s);
                silsum += s;
                x.advance();
            }
            return 1.0 - silsum / (double)this.ids.size();
        }
    }
}

