/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.silhouette;

import elki.clustering.kmedoids.PAM;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.clustering.kmedoids.initialization.KMedoidsKMedoidsInitialization;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.exceptions.AbortException;
import java.util.Arrays;

@References(value={@Reference(authors="M. Van der Laan, K. Pollard, J. Bryan", title="A new partitioning around medoids algorithm", booktitle="Journal of Statistical Computation and Simulation 73(8)", url="https://doi.org/10.1080/0094965031000136012", bibkey="doi:10.1080/0094965031000136012"), @Reference(authors="Lars Lenssen and Erich Schubert", title="Clustering by Direct Optimization of the Medoid Silhouette", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2022", url="https://doi.org/10.1007/978-3-031-17849-8_15", bibkey="DBLP:conf/sisap/LenssenS22")})
public class PAMSIL<O>
extends PAM<O> {
    private static final Logging LOG = Logging.getLogger(PAMSIL.class);

    public PAMSIL(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        Instance instance = new Instance(distQ, ids, assignment);
        double sil = instance.run(medoids, this.maxiter);
        DoubleDataStore silhouettes = instance.silhouetteScores();
        this.getLogger().statistics((Statistic)optd.end());
        Clustering<MedoidModel> res = PAMSIL.wrapResult(ids, assignment, medoids, "PAMSIL Clustering");
        Metadata.hierarchyOf(res).addChild((Object)new MaterializedDoubleRelation("Silhouette scores", ids, silhouettes));
        EvaluationResult ev = EvaluationResult.findOrCreate(res, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Silhouette", sil, -1.0, 1.0, 0.0, false);
        return res;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    extends PAM.Par<O> {
        @Override
        protected Class<? extends KMedoidsInitialization> defaultInitializer() {
            return KMedoidsKMedoidsInitialization.class;
        }

        @Override
        public PAMSIL<O> make() {
            return new PAMSIL(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance {
        DBIDs ids;
        DistanceQuery<?> distQ;
        WritableIntegerDataStore assignment;
        WritableIntegerDataStore scratch;
        WritableDoubleDataStore silhouettes;

        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            this.distQ = distQ;
            this.ids = ids;
            this.assignment = assignment;
            this.scratch = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
            this.silhouettes = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30);
        }

        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int k = medoids.size();
            this.assignToNearestCluster((ArrayDBIDs)medoids);
            double sil = this.silhouette((IntegerDataStore)this.assignment, medoids.size());
            String key = this.getClass().getName().replace("$Instance", "");
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + 0 + ".silhouette", sil));
            }
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAMSIL iteration", LOG) : null;
            DBIDVar bestid = DBIDUtil.newVar();
            DBIDArrayMIter m = medoids.iter();
            int iteration = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                double best = sil;
                int bestcluster = -1;
                DBIDIter h = this.ids.iter();
                while (h.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)h)), (DBIDRef)h)) {
                        for (int pi = 0; pi < k; ++pi) {
                            this.reassignToNearestCluster((IntegerDataStore)this.assignment, this.scratch, (ArrayDBIDs)medoids, pi, (DBIDRef)h);
                            double csil = this.silhouette((IntegerDataStore)this.scratch, k);
                            if (!(csil > best)) continue;
                            best = csil;
                            bestid.set((DBIDRef)h);
                            bestcluster = pi;
                        }
                    }
                    h.advance();
                }
                if (best <= sil) break;
                medoids.set(bestcluster, (DBIDRef)bestid);
                if (LOG.isStatistics()) {
                    LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + iteration + ".silhouette", best));
                }
                sil = best;
                this.reassignToNearestCluster((IntegerDataStore)this.assignment, this.assignment, (ArrayDBIDs)medoids, bestcluster, (DBIDRef)bestid);
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(key + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new DoubleStatistic(key + ".final-silhouette", sil));
            }
            return sil;
        }

        protected void assignToNearestCluster(ArrayDBIDs medoids) {
            DBIDArrayIter miter = medoids.iter();
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                double mindist = Double.POSITIVE_INFINITY;
                int minindx = -1;
                miter.seek(0);
                while (miter.valid()) {
                    double dist = this.distQ.distance((DBIDRef)iditer, (DBIDRef)miter);
                    if (dist < mindist) {
                        minindx = miter.getOffset();
                        mindist = dist;
                    }
                    miter.advance();
                }
                if (minindx < 0) {
                    throw new AbortException("Too many infinite distances. Cannot assign objects.");
                }
                assert (minindx < medoids.size());
                this.assignment.put((DBIDRef)iditer, minindx);
                iditer.advance();
            }
        }

        protected double silhouette(IntegerDataStore assignment, int k) {
            double silsum = 0.0;
            double[] sums = new double[k];
            int[] count = new int[k];
            DBIDIter x = this.ids.iter();
            while (x.valid()) {
                Arrays.fill(sums, 0.0);
                Arrays.fill(count, 0);
                DBIDIter y = this.ids.iter();
                while (y.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)x, (DBIDRef)y)) {
                        int c;
                        int n = c = assignment.intValue((DBIDRef)y);
                        sums[n] = sums[n] + this.distQ.distance((DBIDRef)x, (DBIDRef)y);
                        int n2 = c;
                        count[n2] = count[n2] + 1;
                    }
                    y.advance();
                }
                int c = assignment.intValue((DBIDRef)x);
                if (count[c] != 0) {
                    double a = sums[c] / (double)count[c];
                    double b = Double.POSITIVE_INFINITY;
                    for (int i = 0; i < k; ++i) {
                        if (i == c) continue;
                        double avg = sums[i] / (double)count[i];
                        b = !Double.isNaN(avg) && avg < b ? avg : b;
                    }
                    double s = (b - a) / (a > b ? a : b);
                    this.silhouettes.putDouble((DBIDRef)x, s);
                    silsum += s;
                }
                x.advance();
            }
            return silsum / (double)this.ids.size();
        }

        protected void reassignToNearestCluster(IntegerDataStore prev, WritableIntegerDataStore assignment, ArrayDBIDs medoids, int pi, DBIDRef h) {
            DBIDArrayIter miter = medoids.iter();
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                double od;
                double mindist = this.distQ.distance((DBIDRef)iditer, h);
                int minindx = prev.intValue((DBIDRef)iditer);
                double d = od = DBIDUtil.equal((DBIDRef)miter.seek(minindx), (DBIDRef)h) ? mindist : this.distQ.distance((DBIDRef)iditer, (DBIDRef)miter);
                if (mindist <= od) {
                    minindx = pi;
                } else if (minindx == pi) {
                    miter.seek(0);
                    while (miter.valid()) {
                        double dist;
                        if (miter.getOffset() != pi && (dist = this.distQ.distance((DBIDRef)iditer, (DBIDRef)miter)) < mindist) {
                            minindx = miter.getOffset();
                            mindist = dist;
                        }
                        miter.advance();
                    }
                }
                if (minindx < 0) {
                    throw new AbortException("Too many infinite distances. Cannot assign objects.");
                }
                assignment.put((DBIDRef)iditer, minindx);
                iditer.advance();
            }
        }

        public DoubleDataStore silhouetteScores() {
            return this.silhouettes;
        }
    }
}

