/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.subspace;

import elki.clustering.subspace.DOC;
import elki.data.Cluster;
import elki.data.NumberVector;
import elki.data.model.SubspaceModel;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Title(value="FastDOC: Density-based Optimal projective Clustering")
@Reference(authors="C. M. Procopiuc, M. Jones, P. K. Agarwal, T. M. Murali", title="A Monte Carlo algorithm for fast projective clustering", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '02)", url="https://doi.org/10.1145/564691.564739", bibkey="DBLP:conf/sigmod/ProcopiucJAM02")
public class FastDOC
extends DOC {
    private static final Logging LOG = Logging.getLogger(FastDOC.class);
    private int d_zero;

    public FastDOC(double alpha, double beta, double w, int d_zero, RandomFactory random) {
        super(alpha, beta, w, random);
        this.d_zero = d_zero;
    }

    @Override
    protected Cluster<SubspaceModel> runDOC(Relation<? extends NumberVector> relation, ArrayModifiableDBIDs S, int d, int n, int m, int r, int minClusterSize) {
        long[] D = null;
        DBIDVar dV = DBIDUtil.newVar();
        FiniteProgress iprogress = LOG.isVerbose() ? new FiniteProgress("Iteration progress for current cluster", m * n, LOG) : null;
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDArrayMIter iter = S.iter();
        block0: for (int i = 0; i < n; ++i) {
            iter.seek(random.nextInt(S.size()));
            for (int j = 0; j < m; ++j) {
                ModifiableDBIDs randomSet = DBIDUtil.randomSample((DBIDs)S, (int)r, (Random)random);
                long[] nD = BitsUtil.zero((int)d);
                for (int k = 0; k < d; ++k) {
                    if (!this.dimensionIsRelevant(k, relation, (DBIDs)randomSet)) continue;
                    BitsUtil.setI((long[])nD, (int)k);
                }
                if (D == null || BitsUtil.cardinality((long[])nD) > BitsUtil.cardinality((long[])D)) {
                    D = nD;
                    dV.set((DBIDRef)iter);
                    if (BitsUtil.cardinality((long[])D) >= this.d_zero) {
                        if (iprogress == null) break block0;
                        iprogress.setProcessed(iprogress.getTotal(), LOG);
                        break block0;
                    }
                }
                LOG.incrementProcessed((AbstractProgress)iprogress);
            }
        }
        LOG.ensureCompleted(iprogress);
        if (D == null || BitsUtil.cardinality(D) == 0) {
            return null;
        }
        DBIDs C = this.findNeighbors((DBIDRef)dV, D, S, relation);
        return C.size() >= minClusterSize ? this.makeCluster(relation, C, D) : null;
    }

    public static class Par
    extends DOC.Par {
        public static final OptionID D_ZERO_ID = new OptionID("fastdoc.d0", "Parameter for FastDOC, setting the number of relevant attributes which, when found for a cluster, are deemed enough to stop iterating.");
        protected int d_zero;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(D_ZERO_ID, 5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.d_zero = x;
            });
        }

        @Override
        public FastDOC make() {
            return new FastDOC(this.alpha, this.beta, this.w, this.d_zero, this.random);
        }
    }
}

