/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.subspace;

import elki.clustering.optics.ClusterOrder;
import elki.clustering.optics.CorrelationClusterOrder;
import elki.clustering.optics.GeneralizedOPTICS;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.MillisTimeDuration;
import elki.logging.statistics.Statistic;
import elki.result.Metadata;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="Finding Hierarchies of Subspace Clusters")
@Description(value="Algorithm for detecting hierarchies of subspace clusters.")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Petre Kriegel, Peer Kr\u00f6ger, Ina M\u00fcller-Gorman, Arthur Zimek", title="Finding Hierarchies of Subspace Clusters", booktitle="Proc. 10th Europ. Conf. on Principles and Practice of Knowledge Discovery in Databases (PKDD'06)", url="https://doi.org/10.1007/11871637_42", bibkey="DBLP:conf/pkdd/AchtertBKKMZ06")
public class HiSC
implements GeneralizedOPTICS {
    private static final Logging LOG = Logging.getLogger(HiSC.class);
    private double alpha;
    protected int k;

    public HiSC(double alpha, int k) {
        this.alpha = alpha;
        this.k = k;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public ClusterOrder run(Relation<? extends NumberVector> relation) {
        return new Instance(relation).run();
    }

    public double weightedDistance(NumberVector v1, NumberVector v2, long[] weightVector) {
        double sqrDist = 0.0;
        int i = BitsUtil.nextSetBit((long[])weightVector, (int)0);
        while (i >= 0) {
            double manhattanI = v1.doubleValue(i) - v2.doubleValue(i);
            sqrDist += manhattanI * manhattanI;
            i = BitsUtil.nextSetBit((long[])weightVector, (int)(i + 1));
        }
        return Math.sqrt(sqrDist);
    }

    @Override
    public int getMinPts() {
        return 2;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID EPSILON_ID = new OptionID("hisc.epsilon", "The maximum distance between two vectors with equal preference vectors before considering them as parallel.");
        public static final OptionID ALPHA_ID = new OptionID("hisc.alpha", "The maximum absolute variance along a coordinate axis.");
        public static final double DEFAULT_ALPHA = 0.01;
        public static final OptionID K_ID = new OptionID("hisc.k", "The number of nearest neighbors considered to determine the preference vector. If this value is not defined, k ist set to three times of the dimensionality of the database objects.");
        protected double alpha;
        protected int k = 0;

        public void configure(Parameterization config) {
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(ALPHA_ID, 0.01).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE)).grab(config, x -> {
                this.alpha = x;
            });
            ((IntParameter)((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true)).grab(config, x -> {
                this.k = x;
            });
        }

        public HiSC make() {
            return new HiSC(this.alpha, this.k);
        }
    }

    private class Instance
    extends GeneralizedOPTICS.Instance<CorrelationClusterOrder> {
        protected WritableDataStore<long[]> preferenceVectors;
        private ArrayModifiableDBIDs clusterOrder;
        private Relation<? extends NumberVector> relation;
        private WritableIntegerDataStore correlationValue;
        private WritableDataStore<long[]> commonPreferenceVectors;

        public Instance(Relation<? extends NumberVector> relation) {
            super(relation.getDBIDs());
            this.preferenceVectors = null;
            this.clusterOrder = DBIDUtil.newArray((int)relation.size());
            this.relation = relation;
            this.correlationValue = DataStoreUtil.makeIntegerStorage((DBIDs)relation.getDBIDs(), (int)30, (int)Integer.MAX_VALUE);
            this.commonPreferenceVectors = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)1, long[].class);
        }

        @Override
        public CorrelationClusterOrder run() {
            int usek = HiSC.this.k > 0 ? HiSC.this.k : 3 * RelationUtil.dimensionality(this.relation);
            this.preferenceVectors = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)3, long[].class);
            KNNSearcher knnQuery = new QueryBuilder(this.relation, (Distance)EuclideanDistance.STATIC).kNNByDBID(usek);
            MillisTimeDuration dur = new MillisTimeDuration(this.getClass() + ".preprocessing-time").begin();
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Preprocessing preference vector", this.relation.size(), LOG) : null;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                this.preferenceVectors.put((DBIDRef)it, (Object)this.determinePreferenceVector((DBIDRef)it, (DBIDs)knnQuery.getKNN((Object)it, usek)));
                LOG.incrementProcessed((AbstractProgress)progress);
                it.advance();
            }
            LOG.ensureCompleted(progress);
            LOG.statistics((Statistic)dur.end());
            return (CorrelationClusterOrder)super.run();
        }

        private long[] determinePreferenceVector(DBIDRef id, DBIDs neighborIDs) {
            NumberVector p = (NumberVector)this.relation.get(id);
            int size = neighborIDs.size();
            int dim = p.getDimensionality();
            double[] sumsq = new double[dim];
            DBIDIter iter = neighborIDs.iter();
            while (iter.valid()) {
                NumberVector o = (NumberVector)this.relation.get((DBIDRef)iter);
                int d = 0;
                while (d < dim) {
                    double diff = o.doubleValue(d) - p.doubleValue(d);
                    int n = d++;
                    sumsq[n] = sumsq[n] + diff * diff;
                }
                iter.advance();
            }
            long[] preferenceVector = BitsUtil.zero((int)dim);
            for (int d = 0; d < dim; ++d) {
                if (!(sumsq[d] < HiSC.this.alpha * (double)size)) continue;
                BitsUtil.setI((long[])preferenceVector, (int)d);
            }
            return preferenceVector;
        }

        @Override
        protected CorrelationClusterOrder buildResult() {
            CorrelationClusterOrder result = new CorrelationClusterOrder(this.clusterOrder, this.reachability, this.predecessor, this.correlationValue);
            Metadata.of((Object)result).setLongName("HiCO Cluster Order");
            return result;
        }

        @Override
        protected void initialDBID(DBIDRef id) {
            this.correlationValue.put(id, Integer.MAX_VALUE);
            this.commonPreferenceVectors.put(id, (Object)new long[0]);
        }

        @Override
        protected void expandDBID(DBIDRef id) {
            this.clusterOrder.add(id);
            long[] pv1 = (long[])this.preferenceVectors.get(id);
            NumberVector v1 = (NumberVector)this.relation.get(id);
            int dim = v1.getDimensionality();
            DBIDIter iter = this.relation.iterDBIDs();
            while (iter.valid()) {
                if (!this.processedIDs.contains((DBIDRef)iter)) {
                    int prevdim;
                    long[] pv2 = (long[])this.preferenceVectors.get((DBIDRef)iter);
                    NumberVector v2 = (NumberVector)this.relation.get((DBIDRef)iter);
                    long[] commonPreferenceVector = BitsUtil.andCMin((long[])pv1, (long[])pv2);
                    int subspaceDim = dim - BitsUtil.cardinality((long[])commonPreferenceVector);
                    double dist1 = HiSC.this.weightedDistance(v1, v2, pv1);
                    double dist2 = HiSC.this.weightedDistance(v1, v2, pv2);
                    if (dist1 > HiSC.this.alpha || dist2 > HiSC.this.alpha) {
                        ++subspaceDim;
                        if (LOG.isDebugging()) {
                            LOG.debugFine((CharSequence)new StringBuilder(100).append("dist1 ").append(dist1).append("\ndist2 ").append(dist2).append("\nsubspaceDim ").append(subspaceDim).append("\ncommon pv ").append(BitsUtil.toStringLow((long[])commonPreferenceVector, (int)dim)).toString());
                        }
                    }
                    if ((prevdim = this.correlationValue.intValue((DBIDRef)iter)) >= subspaceDim) {
                        double prevdist;
                        double orthogonalDistance = HiSC.this.weightedDistance(v1, v2, commonPreferenceVector);
                        if (prevdim != subspaceDim || !((prevdist = this.reachability.doubleValue((DBIDRef)iter)) <= orthogonalDistance)) {
                            this.correlationValue.putInt((DBIDRef)iter, subspaceDim);
                            this.reachability.putDouble((DBIDRef)iter, orthogonalDistance);
                            this.predecessor.putDBID((DBIDRef)iter, id);
                            this.commonPreferenceVectors.put((DBIDRef)iter, (Object)commonPreferenceVector);
                            if (prevdim == Integer.MAX_VALUE) {
                                this.candidates.add((DBIDRef)iter);
                            }
                        }
                    }
                }
                iter.advance();
            }
        }

        @Override
        public int compare(DBIDRef o1, DBIDRef o2) {
            int c2;
            int c1 = this.correlationValue.intValue(o1);
            return c1 < (c2 = this.correlationValue.intValue(o2)) ? -1 : (c1 > c2 ? 1 : super.compare(o1, o2));
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

