/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.subspace;

import elki.clustering.AbstractProjectedClustering;
import elki.clustering.subspace.SubspaceClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.Subspace;
import elki.data.model.SubspaceModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.Mean;
import elki.math.linearalgebra.Centroid;
import elki.result.Metadata;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.pairs.Pair;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

@Title(value="PROCLUS: PROjected CLUStering")
@Description(value="Algorithm to find subspace clusters in high dimensional spaces.")
@Reference(authors="C. C. Aggarwal, C. Procopiuc, J. L. Wolf, P. S. Yu, J. S. Park", title="Fast Algorithms for Projected Clustering", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="https://doi.org/10.1145/304181.304188", bibkey="doi:10.1145/304181.304188")
public class PROCLUS
extends AbstractProjectedClustering<Clustering<SubspaceModel>>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(PROCLUS.class);
    private int m_i;
    private RandomFactory rnd;

    public PROCLUS(int k, int k_i, int l, int m_i, RandomFactory rnd) {
        super(k, k_i, l);
        this.m_i = m_i;
        this.rnd = rnd;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public <V extends NumberVector> Clustering<SubspaceModel> run(Relation<V> relation) {
        Object dimensions;
        if (RelationUtil.dimensionality(relation) < this.l) {
            throw new IllegalStateException("Dimensionality of data < parameter l! (" + RelationUtil.dimensionality(relation) + " < " + this.l + ")");
        }
        QueryBuilder qb = new QueryBuilder(relation, (Distance)SquaredEuclideanDistance.STATIC);
        DistanceQuery distFunc = qb.distanceQuery();
        RangeSearcher rangeQuery = qb.rangeByDBID();
        Random random = this.rnd.getSingleThreadedRandom();
        StepProgress stepp = new StepProgress(3);
        stepp.beginStep(1, "Initialization phase", LOG);
        int sampleSize = Math.min(relation.size(), this.k_i * this.k);
        ModifiableDBIDs sampleSet = DBIDUtil.randomSample((DBIDs)relation.getDBIDs(), (int)sampleSize, (Random)random);
        int medoidSize = Math.min(relation.size(), this.m_i * this.k);
        ArrayDBIDs medoids = this.greedy((DistanceQuery<? extends NumberVector>)distFunc, (DBIDs)sampleSet, medoidSize, random);
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("sampleSize " + sampleSize + '\n' + "sampleSet " + sampleSet + '\n' + "medoidSize " + medoidSize + '\n' + "m " + medoids));
        }
        stepp.beginStep(2, "Iterative phase", LOG);
        double bestObjective = Double.POSITIVE_INFINITY;
        ArrayDBIDs m_best = null;
        DBIDs m_bad = null;
        ArrayDBIDs m_current = this.initialSet((DBIDs)medoids, this.k, random);
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("m_c " + m_current));
        }
        IndefiniteProgress cprogress = LOG.isVerbose() ? new IndefiniteProgress("Current number of clusters:", LOG) : null;
        ArrayList<PROCLUSCluster> clusters = null;
        for (int loops = 0; loops < 10; ++loops) {
            dimensions = this.findDimensions(m_current, relation, (DistanceQuery<? extends NumberVector>)distFunc, (RangeSearcher<DBIDRef>)rangeQuery);
            clusters = this.assignPoints(m_current, (long[][])dimensions, (Relation<? extends NumberVector>)relation);
            double objectiveFunction = this.evaluateClusters(clusters, (long[][])dimensions, (Relation<? extends NumberVector>)relation);
            if (objectiveFunction < bestObjective) {
                loops = 0;
                bestObjective = objectiveFunction;
                m_best = m_current;
                m_bad = this.computeBadMedoids(m_current, clusters, (int)((double)relation.size() * 0.1 / (double)this.k));
            }
            m_current = this.computeM_current((DBIDs)medoids, (DBIDs)m_best, m_bad, random);
            if (cprogress == null) continue;
            cprogress.setProcessed(clusters.size(), LOG);
        }
        LOG.setCompleted(cprogress);
        stepp.beginStep(3, "Refinement phase", LOG);
        dimensions = this.findDimensions(clusters, relation);
        List<PROCLUSCluster> finalClusters = this.finalAssignment((List<Pair<double[], long[]>>)dimensions, relation);
        stepp.setCompleted(LOG);
        int numClusters = 1;
        Clustering<SubspaceModel> result = new Clustering<SubspaceModel>();
        Metadata.of(result).setLongName("ProClus Clustering");
        for (PROCLUSCluster c : finalClusters) {
            Cluster<SubspaceModel> cluster = new Cluster<SubspaceModel>((DBIDs)c.objectIDs);
            cluster.setModel(new SubspaceModel(new Subspace(c.getDimensions()), c.centroid));
            cluster.setName("cluster_" + numClusters++);
            result.addToplevelCluster(cluster);
        }
        return result;
    }

    private ArrayDBIDs greedy(DistanceQuery<? extends NumberVector> distance, DBIDs sampleSet, int m, Random random) {
        ArrayModifiableDBIDs medoids = DBIDUtil.newArray((int)m);
        ArrayModifiableDBIDs s = DBIDUtil.newArray((DBIDs)sampleSet);
        DBIDArrayMIter iter = s.iter();
        DBIDVar mi = DBIDUtil.newVar();
        int size = s.size();
        s.swap(random.nextInt(size), --size);
        medoids.add((DBIDRef)s.pop(mi));
        if (LOG.isDebugging()) {
            LOG.debugFiner((CharSequence)("medoids " + medoids.toString()));
        }
        int worst = -1;
        double worstd = Double.NEGATIVE_INFINITY;
        WritableDoubleDataStore distances = DataStoreUtil.makeDoubleStorage((DBIDs)s, (int)3);
        iter.seek(0);
        while (iter.getOffset() < size) {
            double dist = distance.distance((DBIDRef)iter, (DBIDRef)mi);
            distances.putDouble((DBIDRef)iter, dist);
            if (dist > worstd) {
                worstd = dist;
                worst = iter.getOffset();
            }
            iter.advance();
        }
        for (int i = 1; i < m; ++i) {
            s.swap(worst, --size);
            medoids.add((DBIDRef)s.pop(mi));
            worst = -1;
            worstd = Double.NEGATIVE_INFINITY;
            iter.seek(0);
            while (iter.getOffset() < size) {
                double dist_old;
                double dist_new = distance.distance((DBIDRef)iter, (DBIDRef)mi);
                double dist = dist_new < (dist_old = distances.doubleValue((DBIDRef)iter)) ? dist_new : dist_old;
                distances.putDouble((DBIDRef)iter, dist);
                if (dist > worstd) {
                    worstd = dist;
                    worst = iter.getOffset();
                }
                iter.advance();
            }
            if (!LOG.isDebugging()) continue;
            LOG.debugFiner((CharSequence)("medoids " + medoids.toString()));
        }
        return medoids;
    }

    private ArrayDBIDs initialSet(DBIDs sampleSet, int k, Random random) {
        return DBIDUtil.ensureArray((DBIDs)DBIDUtil.randomSample((DBIDs)sampleSet, (int)k, (Random)random));
    }

    private ArrayDBIDs computeM_current(DBIDs m, DBIDs m_best, DBIDs m_bad, Random random) {
        ArrayModifiableDBIDs m_list = DBIDUtil.newArray((DBIDs)m);
        m_list.removeDBIDs(m_best);
        DBIDArrayMIter it = m_list.iter();
        ArrayModifiableDBIDs m_current = DBIDUtil.newArray();
        DBIDIter iter = m_best.iter();
        while (iter.valid()) {
            if (m_bad.contains((DBIDRef)iter)) {
                int currentSize = m_current.size();
                while (m_current.size() == currentSize) {
                    m_current.add((DBIDRef)it.seek(random.nextInt(m_list.size())));
                    it.remove();
                }
            } else {
                m_current.add((DBIDRef)iter);
            }
            iter.advance();
        }
        return m_current;
    }

    private DataStore<DBIDs> getLocalities(DBIDs medoids, DistanceQuery<? extends NumberVector> distance, RangeSearcher<DBIDRef> rangeQuery) {
        WritableDataStore result = DataStoreUtil.makeStorage((DBIDs)medoids, (int)3, DBIDs.class);
        DBIDIter iter = medoids.iter();
        while (iter.valid()) {
            double minDist = Double.POSITIVE_INFINITY;
            DBIDIter iter2 = medoids.iter();
            while (iter2.valid()) {
                double currentDist;
                if (!DBIDUtil.equal((DBIDRef)iter, (DBIDRef)iter2) && (currentDist = distance.distance((DBIDRef)iter, (DBIDRef)iter2)) < minDist) {
                    minDist = currentDist;
                }
                iter2.advance();
            }
            assert (minDist != Double.POSITIVE_INFINITY);
            result.put((DBIDRef)iter, (Object)rangeQuery.getRange((Object)iter, minDist));
            iter.advance();
        }
        return result;
    }

    private long[][] findDimensions(ArrayDBIDs medoids, Relation<? extends NumberVector> relation, DistanceQuery<? extends NumberVector> distance, RangeSearcher<DBIDRef> rangeQuery) {
        DataStore<DBIDs> localities = this.getLocalities((DBIDs)medoids, distance, rangeQuery);
        int dim = RelationUtil.dimensionality(relation);
        int numc = medoids.size();
        double[][] averageDistances = new double[numc][];
        DBIDArrayIter iter = medoids.iter();
        while (iter.valid()) {
            NumberVector medoid_i = (NumberVector)relation.get((DBIDRef)iter);
            DBIDs l_i = (DBIDs)localities.get((DBIDRef)iter);
            double[] x_i = new double[dim];
            DBIDIter qr = l_i.iter();
            while (qr.valid()) {
                NumberVector o = (NumberVector)relation.get((DBIDRef)qr);
                for (int d = 0; d < dim; ++d) {
                    int n = d;
                    x_i[n] = x_i[n] + Math.abs(medoid_i.doubleValue(d) - o.doubleValue(d));
                }
                qr.advance();
            }
            int d = 0;
            while (d < dim) {
                int n = d++;
                x_i[n] = x_i[n] / (double)l_i.size();
            }
            averageDistances[iter.getOffset()] = x_i;
            iter.advance();
        }
        return this.computeDimensionMap(this.computeZijs(averageDistances, dim), dim, numc);
    }

    private List<Pair<double[], long[]>> findDimensions(ArrayList<PROCLUSCluster> clusters, Relation<? extends NumberVector> database) {
        int dim = RelationUtil.dimensionality(database);
        int numc = clusters.size();
        double[][] averageDistances = new double[numc][];
        for (int i = 0; i < numc; ++i) {
            PROCLUSCluster c_i = clusters.get(i);
            double[] x_i = new double[dim];
            DBIDMIter iter = c_i.objectIDs.iter();
            while (iter.valid()) {
                NumberVector o = (NumberVector)database.get((DBIDRef)iter);
                for (int d = 0; d < dim; ++d) {
                    int n = d;
                    x_i[n] = x_i[n] + Math.abs(c_i.centroid[d] - o.doubleValue(d));
                }
                iter.advance();
            }
            int d = 0;
            while (d < dim) {
                int n = d++;
                x_i[n] = x_i[n] / (double)c_i.objectIDs.size();
            }
            averageDistances[i] = x_i;
        }
        List<DoubleIntInt> z_ijs = this.computeZijs(averageDistances, dim);
        long[][] dimensionMap = this.computeDimensionMap(z_ijs, dim, numc);
        ArrayList<Pair<double[], long[]>> result = new ArrayList<Pair<double[], long[]>>(numc);
        for (int i = 0; i < numc; ++i) {
            long[] dims_i = dimensionMap[i];
            if (dims_i == null) continue;
            result.add((Pair<double[], long[]>)new Pair((Object)clusters.get((int)i).centroid, (Object)dims_i));
        }
        return result;
    }

    private List<DoubleIntInt> computeZijs(double[][] averageDistances, int dim) {
        ArrayList<DoubleIntInt> z_ijs = new ArrayList<DoubleIntInt>(averageDistances.length * dim);
        for (int i = 0; i < averageDistances.length; ++i) {
            int j;
            double[] x_i = averageDistances[i];
            double y_i = 0.0;
            for (int j2 = 0; j2 < dim; ++j2) {
                y_i += x_i[j2];
            }
            y_i /= (double)dim;
            double sigma_i = 0.0;
            for (j = 0; j < dim; ++j) {
                double diff = x_i[j] - y_i;
                sigma_i += diff * diff;
            }
            sigma_i /= (double)(dim - 1);
            sigma_i = Math.sqrt(sigma_i);
            for (j = 0; j < dim; ++j) {
                z_ijs.add(new DoubleIntInt((x_i[j] - y_i) / sigma_i, i, j));
            }
        }
        Collections.sort(z_ijs);
        return z_ijs;
    }

    private long[][] computeDimensionMap(List<DoubleIntInt> z_ijs, int dim, int numc) {
        long[][] dimensionMap = new long[numc][(dim - 1 >> 6) + 1];
        int max = Math.max(this.k * this.l, 2);
        for (int m = 0; m < max; ++m) {
            DoubleIntInt z_ij = z_ijs.get(m);
            long[] dims_i = dimensionMap[z_ij.dimi];
            BitsUtil.setI((long[])dims_i, (int)z_ij.dimj);
            if (!LOG.isDebugging()) continue;
            LOG.debugFiner((CharSequence)("z_ij " + z_ij + '\n' + "D_i " + BitsUtil.toString((long[])dims_i)));
        }
        return dimensionMap;
    }

    private ArrayList<PROCLUSCluster> assignPoints(ArrayDBIDs m_current, long[][] dimensions, Relation<? extends NumberVector> database) {
        ModifiableDBIDs[] clusterIDs = new ModifiableDBIDs[dimensions.length];
        for (int i = 0; i < m_current.size(); ++i) {
            clusterIDs[i] = DBIDUtil.newHashSet();
        }
        DBIDArrayIter mi = m_current.iter();
        DBIDIter it = database.iterDBIDs();
        while (it.valid()) {
            NumberVector p = (NumberVector)database.get((DBIDRef)it);
            double minDist = Double.NaN;
            int best = -1;
            int i = 0;
            mi.seek(0);
            while (mi.valid()) {
                NumberVector m = (NumberVector)database.get((DBIDRef)mi);
                double currentDist = this.manhattanSegmentalDistance(p, m, dimensions[i]);
                if (!(minDist <= currentDist)) {
                    minDist = currentDist;
                    best = i;
                }
                mi.advance();
                ++i;
            }
            assert (best >= 0);
            clusterIDs[best].add((DBIDRef)it);
            it.advance();
        }
        ArrayList<PROCLUSCluster> clusters = new ArrayList<PROCLUSCluster>(m_current.size());
        for (int i = 0; i < dimensions.length; ++i) {
            ModifiableDBIDs objectIDs = clusterIDs[i];
            if (!objectIDs.isEmpty()) {
                long[] clusterDimensions = dimensions[i];
                double[] centroid = Centroid.make(database, (DBIDs)objectIDs).getArrayRef();
                clusters.add(new PROCLUSCluster(objectIDs, clusterDimensions, centroid));
                continue;
            }
            clusters.add(null);
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("clusters " + clusters));
        }
        return clusters;
    }

    private List<PROCLUSCluster> finalAssignment(List<Pair<double[], long[]>> dimensions, Relation<? extends NumberVector> database) {
        HashMap<Integer, HashSetModifiableDBIDs> clusterIDs = new HashMap<Integer, HashSetModifiableDBIDs>();
        for (int i = 0; i < dimensions.size(); ++i) {
            clusterIDs.put(i, DBIDUtil.newHashSet());
        }
        DBIDIter it = database.iterDBIDs();
        while (it.valid()) {
            NumberVector p = (NumberVector)database.get((DBIDRef)it);
            double minDist = Double.POSITIVE_INFINITY;
            int best = -1;
            for (int i = 0; i < dimensions.size(); ++i) {
                Pair<double[], long[]> pair_i = dimensions.get(i);
                double currentDist = this.manhattanSegmentalDistance(p, (double[])pair_i.first, (long[])pair_i.second);
                if (best >= 0 && !(currentDist < minDist)) continue;
                minDist = currentDist;
                best = i;
            }
            assert (minDist >= 0.0);
            ((ModifiableDBIDs)clusterIDs.get(best)).add((DBIDRef)it);
            it.advance();
        }
        ArrayList<PROCLUSCluster> clusters = new ArrayList<PROCLUSCluster>();
        for (int i = 0; i < dimensions.size(); ++i) {
            ModifiableDBIDs objectIDs = (ModifiableDBIDs)clusterIDs.get(i);
            if (objectIDs.isEmpty()) continue;
            long[] clusterDimensions = (long[])dimensions.get((int)i).second;
            double[] centroid = Centroid.make(database, (DBIDs)objectIDs).getArrayRef();
            clusters.add(new PROCLUSCluster(objectIDs, clusterDimensions, centroid));
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("clusters " + clusters));
        }
        return clusters;
    }

    private double manhattanSegmentalDistance(NumberVector o1, NumberVector o2, long[] dimensions) {
        double result = 0.0;
        int card = 0;
        int d = BitsUtil.nextSetBit((long[])dimensions, (int)0);
        while (d >= 0) {
            result += Math.abs(o1.doubleValue(d) - o2.doubleValue(d));
            ++card;
            d = BitsUtil.nextSetBit((long[])dimensions, (int)(d + 1));
        }
        return result / (double)card;
    }

    private double manhattanSegmentalDistance(NumberVector o1, double[] o2, long[] dimensions) {
        double result = 0.0;
        int card = 0;
        int d = BitsUtil.nextSetBit((long[])dimensions, (int)0);
        while (d >= 0) {
            result += Math.abs(o1.doubleValue(d) - o2[d]);
            ++card;
            d = BitsUtil.nextSetBit((long[])dimensions, (int)(d + 1));
        }
        return result / (double)card;
    }

    private double evaluateClusters(ArrayList<PROCLUSCluster> clusters, long[][] dimensions, Relation<? extends NumberVector> database) {
        double result = 0.0;
        for (int i = 0; i < dimensions.length; ++i) {
            PROCLUSCluster c_i = clusters.get(i);
            double[] centroid_i = c_i.centroid;
            long[] dims_i = dimensions[i];
            double w_i = 0.0;
            int d = BitsUtil.nextSetBit((long[])dims_i, (int)0);
            while (d >= 0) {
                w_i += this.avgDistance(centroid_i, (DBIDs)c_i.objectIDs, database, d);
                d = BitsUtil.nextSetBit((long[])dims_i, (int)(d + 1));
            }
            result += (double)c_i.objectIDs.size() * (w_i /= (double)dimensions.length);
        }
        return result / (double)database.size();
    }

    private double avgDistance(double[] centroid, DBIDs objectIDs, Relation<? extends NumberVector> database, int dimension) {
        Mean avg = new Mean();
        DBIDIter iter = objectIDs.iter();
        while (iter.valid()) {
            avg.put(Math.abs(centroid[dimension] - ((NumberVector)database.get((DBIDRef)iter)).doubleValue(dimension)));
            iter.advance();
        }
        return avg.getMean();
    }

    private DBIDs computeBadMedoids(ArrayDBIDs m_current, ArrayList<PROCLUSCluster> clusters, int threshold) {
        HashSetModifiableDBIDs badMedoids = DBIDUtil.newHashSet((int)m_current.size());
        int i = 0;
        DBIDArrayIter it = m_current.iter();
        while (it.valid()) {
            PROCLUSCluster c_i = clusters.get(i);
            if (c_i == null || c_i.objectIDs.size() < threshold) {
                badMedoids.add((DBIDRef)it);
            }
            it.advance();
            ++i;
        }
        return badMedoids;
    }

    public static class Par
    extends AbstractProjectedClustering.Par {
        public static final OptionID M_I_ID = new OptionID("proclus.mi", "The multiplier for the initial number of medoids.");
        public static final OptionID SEED_ID = new OptionID("proclus.seed", "The random number generator seed.");
        protected int m_i = -1;
        protected RandomFactory rnd;

        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ((IntParameter)new IntParameter(K_I_ID, 30).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k_i = x;
            });
            ((IntParameter)new IntParameter(L_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.l = x;
            });
            ((IntParameter)new IntParameter(M_I_ID, 10).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.m_i = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public PROCLUS make() {
            return new PROCLUS(this.k, this.k_i, this.l, this.m_i, this.rnd);
        }
    }

    private static class PROCLUSCluster {
        ModifiableDBIDs objectIDs;
        long[] dimensions;
        double[] centroid;

        public PROCLUSCluster(ModifiableDBIDs objectIDs, long[] dimensions, double[] centroid) {
            this.objectIDs = objectIDs;
            this.dimensions = dimensions;
            this.centroid = centroid;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(500).append("Dimensions: [");
            boolean notFirst = false;
            int d = BitsUtil.nextSetBit((long[])this.dimensions, (int)0);
            while (d >= 0) {
                if (notFirst) {
                    result.append(',');
                }
                notFirst = true;
                result.append(d);
                d = BitsUtil.nextSetBit((long[])this.dimensions, (int)(d + 1));
            }
            return FormatUtil.formatTo((StringBuilder)result.append("]\nCentroid: "), (double[])this.centroid, (String)",").toString();
        }

        public long[] getDimensions() {
            return this.dimensions;
        }
    }

    private static class DoubleIntInt
    implements Comparable<DoubleIntInt> {
        protected double first;
        protected int dimi;
        protected int dimj;

        public DoubleIntInt(double first, int second, int third) {
            this.first = first;
            this.dimi = second;
            this.dimj = third;
        }

        @Override
        public int compareTo(DoubleIntInt o) {
            return this.first < o.first ? -1 : (this.first > o.first ? 1 : 0);
        }
    }
}

