/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.subspace;

import elki.clustering.dbscan.DBSCAN;
import elki.clustering.dbscan.GeneralizedDBSCAN;
import elki.clustering.dbscan.predicates.PreDeConCorePredicate;
import elki.clustering.dbscan.predicates.PreDeConNeighborPredicate;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="PreDeCon: Subspace Preference weighted Density Connected Clustering")
@Description(value="PreDeCon computes clusters of subspace preference weighted connected points. The algorithm searches for local subgroups of a set of feature vectors having a low variance along one or more (but not all) attributes.")
@Reference(authors="Christian B\u00f6hm, Karin Kailing, Hans-Peter Kriegel, Peer Kr\u00f6ger", title="Density Connected Clustering with Local Subspace Preferences", booktitle="Proc. 4th IEEE Int. Conf. on Data Mining (ICDM'04)", url="https://doi.org/10.1109/ICDM.2004.10087", bibkey="DBLP:conf/icdm/BohmKKK04")
public class PreDeCon
extends GeneralizedDBSCAN {
    public PreDeCon(Settings settings) {
        super(new PreDeConNeighborPredicate(settings), new PreDeConCorePredicate(settings), false);
    }

    public static class Par
    implements Parameterizer {
        protected Settings settings;

        public void configure(Parameterization config) {
            this.settings = (Settings)config.tryInstantiate(Settings.class);
        }

        public PreDeCon make() {
            return new PreDeCon(this.settings);
        }
    }

    public static class Settings {
        public double epsilon;
        public double delta;
        public double kappa = 20.0;
        public int minpts;
        public int lambda = Integer.MAX_VALUE;

        public static class Par
        implements Parameterizer {
            public static final OptionID DELTA_ID = new OptionID("predecon.delta", "A double specifying the variance threshold for small Eigenvalues.");
            public static final OptionID KAPPA_ID = new OptionID("predecon.kappa", "Penalty factor for deviations in preferred (low-variance) dimensions.");
            public static final double KAPPA_DEFAULT = 20.0;
            public static final OptionID LAMBDA_ID = new OptionID("predecon.lambda", "Maximum dimensionality to consider for core points.");
            Settings settings;

            public void configure(Parameterization config) {
                this.settings = new Settings();
                this.configEpsilon(config);
                this.configMinPts(config);
                this.configDelta(config);
                this.configKappa(config);
                this.configLambda(config);
            }

            protected void configEpsilon(Parameterization config) {
                ((DoubleParameter)new DoubleParameter(DBSCAN.Par.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                    this.settings.epsilon = x;
                });
            }

            protected void configMinPts(Parameterization config) {
                ((IntParameter)new IntParameter(DBSCAN.Par.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.settings.minpts = x;
                });
            }

            protected void configDelta(Parameterization config) {
                ((DoubleParameter)new DoubleParameter(DELTA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                    this.settings.delta = x;
                });
            }

            protected void configKappa(Parameterization config) {
                ((DoubleParameter)((DoubleParameter)new DoubleParameter(KAPPA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_DOUBLE)).setDefaultValue((Object)20.0)).grab(config, x -> {
                    this.settings.kappa = x;
                });
            }

            protected void configLambda(Parameterization config) {
                ((IntParameter)((IntParameter)new IntParameter(LAMBDA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true)).grab(config, x -> {
                    this.settings.lambda = x;
                });
            }

            public Settings make() {
                return this.settings;
            }
        }
    }
}

