/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.subspace.clique;

import elki.clustering.subspace.clique.CLIQUEUnit;
import elki.data.Subspace;
import elki.database.ids.DBIDUtil;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.pairs.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CLIQUESubspace
extends Subspace {
    private List<CLIQUEUnit> denseUnits = new ArrayList<CLIQUEUnit>();
    private int coverage = 0;
    public static final Comparator<CLIQUESubspace> BY_COVERAGE = (s1, s2) -> Integer.compare(s2.getCoverage(), s1.getCoverage());

    public CLIQUESubspace(int dimension) {
        super(dimension);
    }

    public CLIQUESubspace(long[] dimensions) {
        super(dimensions);
    }

    public void addDenseUnit(CLIQUEUnit unit) {
        int numdim = unit.dimensionality();
        for (int i = 0; i < numdim; ++i) {
            BitsUtil.setI((long[])this.getDimensions(), (int)unit.getDimension(i));
        }
        this.denseUnits.add(unit);
        this.coverage += unit.numberOfFeatureVectors();
    }

    public List<Pair<Subspace, ModifiableDBIDs>> determineClusters() {
        ArrayList<Pair<Subspace, ModifiableDBIDs>> clusters = new ArrayList<Pair<Subspace, ModifiableDBIDs>>();
        for (CLIQUEUnit unit : this.denseUnits) {
            if (unit.isAssigned()) continue;
            HashSetModifiableDBIDs cluster = DBIDUtil.newHashSet();
            CLIQUESubspace model = new CLIQUESubspace(this.getDimensions());
            clusters.add((Pair<Subspace, ModifiableDBIDs>)new Pair((Object)model, (Object)cluster));
            this.dfs(unit, (ModifiableDBIDs)cluster, model);
        }
        return clusters;
    }

    public void dfs(CLIQUEUnit unit, ModifiableDBIDs cluster, CLIQUESubspace model) {
        cluster.addDBIDs(unit.getIds());
        unit.markAsAssigned();
        model.addDenseUnit(unit);
        long[] dims = this.getDimensions();
        int dim = BitsUtil.nextSetBit((long[])dims, (int)0);
        while (dim >= 0) {
            CLIQUEUnit right;
            CLIQUEUnit left = this.leftNeighbor(unit, dim);
            if (left != null && !left.isAssigned()) {
                this.dfs(left, cluster, model);
            }
            if ((right = this.rightNeighbor(unit, dim)) != null && !right.isAssigned()) {
                this.dfs(right, cluster, model);
            }
            dim = BitsUtil.nextSetBit((long[])dims, (int)(dim + 1));
        }
    }

    protected CLIQUEUnit leftNeighbor(CLIQUEUnit unit, int dim) {
        for (CLIQUEUnit u : this.denseUnits) {
            if (!u.containsLeftNeighbor(unit, dim)) continue;
            return u;
        }
        return null;
    }

    protected CLIQUEUnit rightNeighbor(CLIQUEUnit unit, int dim) {
        for (CLIQUEUnit u : this.denseUnits) {
            if (!u.containsRightNeighbor(unit, dim)) continue;
            return u;
        }
        return null;
    }

    public int getCoverage() {
        return this.coverage;
    }

    public CLIQUESubspace join(CLIQUESubspace other, double all, double tau) {
        long[] dimensions = this.joinLastDimensions(other);
        if (dimensions == null) {
            return null;
        }
        CLIQUESubspace s = new CLIQUESubspace(dimensions);
        for (CLIQUEUnit u1 : this.denseUnits) {
            for (CLIQUEUnit u2 : other.denseUnits) {
                CLIQUEUnit u = u1.join(u2, all, tau);
                if (u == null) continue;
                s.addDenseUnit(u);
            }
        }
        return s.denseUnits.isEmpty() ? null : s;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(1000).append(super.toString()).append("\nCoverage: ").append(this.coverage).append("\nUnits: \n");
        for (CLIQUEUnit denseUnit : this.denseUnits) {
            result.append("   ").append(denseUnit.toString()).append("   ").append(denseUnit.getIds().size()).append(" objects\n");
        }
        return result.toString();
    }
}

