/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.trivial;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.trivial.ReferenceClustering;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.NoSupportedDataTypeException;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Title(value="Hierarchical clustering by label")
@Description(value="Cluster points by a (pre-assigned!) label. For comparing results with a reference clustering.")
@Priority(value=-105)
public class ByLabelHierarchicalClustering
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(ByLabelHierarchicalClustering.class);

    @Override
    public Clustering<Model> autorun(Database database) {
        try {
            return this.run(database.getRelation((TypeInformation)TypeUtil.CLASSLABEL, new Object[0]));
        }
        catch (NoSupportedDataTypeException e) {
            return this.run(database.getRelation(this.getInputTypeRestriction()[0], new Object[0]));
        }
    }

    public Clustering<Model> run(Relation<?> relation) {
        HashMap<String, DBIDs> labelmap = new HashMap<String, DBIDs>();
        ArrayModifiableDBIDs noiseids = DBIDUtil.newArray();
        ReferenceClustering<Model> clustering = new ReferenceClustering<Model>();
        Metadata.of(clustering).setLongName("By Label Hierarchical Clustering");
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            Iterator val = relation.get((DBIDRef)iditer);
            if (val == null) {
                noiseids.add((DBIDRef)iditer);
            } else {
                this.assign(labelmap, val.toString(), (DBIDRef)iditer);
            }
            iditer.advance();
        }
        ArrayList<Cluster<ClusterModel>> clusters = new ArrayList<Cluster<ClusterModel>>(labelmap.size());
        for (Map.Entry entry : labelmap.entrySet()) {
            DBIDs ids = (DBIDs)entry.getValue();
            if (ids instanceof DBID) {
                noiseids.add((DBIDRef)((DBID)ids));
                continue;
            }
            clusters.add(new Cluster<ClusterModel>((String)entry.getKey(), ids, ClusterModel.CLUSTER));
        }
        for (Cluster cluster : clusters) {
            Cluster bestparent = null;
            for (Cluster cluster2 : clusters) {
                if (cluster2 == cluster || !cluster.getName().startsWith(cluster2.getName()) || bestparent != null && cluster2.getName().length() <= bestparent.getName().length()) continue;
                bestparent = cluster2;
            }
            if (bestparent != null) {
                if (LOG.isDebuggingFiner()) {
                    LOG.debugFiner((CharSequence)(cluster.getName() + " is a child of " + bestparent.getName()));
                }
                clustering.addChildCluster(bestparent, cluster);
                continue;
            }
            clustering.addToplevelCluster(cluster);
        }
        if (!noiseids.isEmpty()) {
            Cluster<ClusterModel> c = new Cluster<ClusterModel>("Noise", (DBIDs)noiseids, ClusterModel.CLUSTER);
            c.setNoise(true);
            clustering.addToplevelCluster(c);
        }
        return clustering;
    }

    private void assign(HashMap<String, DBIDs> labelMap, String label, DBIDRef id) {
        if (labelMap.containsKey(label)) {
            DBIDs exist = labelMap.get(label);
            if (exist instanceof DBID) {
                HashSetModifiableDBIDs n = DBIDUtil.newHashSet();
                n.add((DBIDRef)((DBID)exist));
                n.add(id);
                labelMap.put(label, (DBIDs)n);
            } else {
                assert (exist instanceof HashSetModifiableDBIDs);
                assert (exist.size() > 1);
                ((ModifiableDBIDs)exist).add(id);
            }
        } else {
            labelMap.put(label, (DBIDs)DBIDUtil.deref((DBIDRef)id));
        }
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.GUESSED_LABEL});
    }
}

