/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.trivial;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.trivial.ReferenceClustering;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.relation.Relation;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;

@Title(value="Trivial all-in-one clustering")
@Description(value="Returns a 'tivial' clustering which just considers all points to be one big cluster.")
@Priority(value=-150)
public class TrivialAllInOne
implements ClusteringAlgorithm<Clustering<Model>> {
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.ANY});
    }

    public Clustering<Model> run(Relation<?> relation) {
        ReferenceClustering<Model> result = new ReferenceClustering<Model>();
        Metadata.of(result).setLongName("All-in-one Trivial Clustering");
        result.addToplevelCluster(new Cluster<ClusterModel>(relation.getDBIDs(), ClusterModel.CLUSTER));
        return result;
    }
}

