/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.trivial;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.trivial.ReferenceClustering;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.relation.Relation;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;

@Title(value="Trivial all-noise clustering")
@Description(value="Returns a 'trivial' clustering which just considers all points as noise points.")
@Priority(value=-150)
public class TrivialAllNoise
implements ClusteringAlgorithm<Clustering<Model>> {
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.ANY});
    }

    public Clustering<Model> run(Relation<?> relation) {
        ReferenceClustering<Model> result = new ReferenceClustering<Model>();
        Metadata.of(result).setLongName("All-in-noise Trivial Clustering");
        result.addToplevelCluster(new Cluster<ClusterModel>(relation.getDBIDs(), true, ClusterModel.CLUSTER));
        return result;
    }
}

