/*
 * Decompiled with CFR 0.152.
 */
package elki.data;

import elki.data.model.Model;
import elki.database.ids.DBIDs;
import elki.result.textwriter.TextWriteable;
import elki.result.textwriter.TextWriterStream;
import java.util.Comparator;

public class Cluster<M extends Model>
implements TextWriteable {
    protected String name = null;
    private DBIDs ids = null;
    private M model = null;
    private boolean noise = false;
    public static final Comparator<Cluster<?>> BY_NAME_SORTER = (o1, o2) -> o1 == o2 ? 0 : (o1 == null ? 1 : (o2 == null ? -1 : (o1.name == o2.name ? 0 : (o1.name == null ? 1 : (o2.name == null ? -1 : o1.name.compareTo(o2.name))))));

    public Cluster(String name, DBIDs ids, boolean noise, M model) {
        this.name = name;
        this.ids = ids;
        this.noise = noise;
        this.model = model;
    }

    public Cluster(String name, DBIDs ids, M model) {
        this(name, ids, false, model);
    }

    public Cluster(DBIDs ids, boolean noise, M model) {
        this(null, ids, noise, model);
    }

    public Cluster(DBIDs ids, M model) {
        this(null, ids, false, model);
    }

    public Cluster(String name, DBIDs ids, boolean noise) {
        this(name, ids, noise, null);
    }

    public Cluster(String name, DBIDs ids) {
        this(name, ids, false, null);
    }

    public Cluster(DBIDs ids, boolean noise) {
        this(null, ids, noise, null);
    }

    public Cluster(DBIDs ids) {
        this(null, ids, false, null);
    }

    public int size() {
        return this.ids.size();
    }

    public String getNameAutomatic() {
        return this.name != null ? this.name : (this.isNoise() ? "Noise" : "Cluster");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DBIDs getIDs() {
        return this.ids;
    }

    public void setIDs(DBIDs g) {
        this.ids = g;
    }

    public M getModel() {
        return this.model;
    }

    public void setModel(M model) {
        this.model = model;
    }

    public void writeToText(TextWriterStream out, String label) {
        String nam = this.getNameAutomatic();
        if (nam != null) {
            out.commentPrintLn((CharSequence)("Cluster name: " + nam));
        }
        out.commentPrintLn((CharSequence)("Cluster noise flag: " + this.isNoise()));
        out.commentPrintLn((CharSequence)("Cluster size: " + this.ids.size()));
        if (this.getModel() instanceof TextWriteable) {
            ((TextWriteable)this.getModel()).writeToText(out, label);
        }
    }

    public boolean isNoise() {
        return this.noise;
    }

    public void setNoise(boolean noise) {
        this.noise = noise;
    }

    public String toString() {
        return "Cluster(name=" + this.getName() + ",size=" + this.size() + ",model=" + (this.model == null ? "null" : this.model.toString()) + (this.noise ? ",noise" : "") + ")";
    }
}

