/*
 * Decompiled with CFR 0.152.
 */
package elki.data;

import elki.data.Cluster;
import elki.data.model.Model;
import elki.data.type.SimpleTypeInformation;
import elki.result.Metadata;
import elki.utilities.datastructures.hierarchy.HashMapHierarchy;
import elki.utilities.datastructures.hierarchy.Hierarchy;
import elki.utilities.datastructures.hierarchy.ModifiableHierarchy;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.datastructures.iterator.IterableIt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Clustering<M extends Model> {
    public static final SimpleTypeInformation<Clustering<?>> TYPE = new SimpleTypeInformation(Clustering.class);
    private List<Cluster<M>> toplevelclusters;
    private ModifiableHierarchy<Cluster<M>> hierarchy;

    public Clustering(List<Cluster<M>> toplevelclusters) {
        this.toplevelclusters = toplevelclusters;
        this.hierarchy = new HashMapHierarchy();
        for (Cluster<M> clus : toplevelclusters) {
            this.hierarchy.add(clus);
        }
    }

    public Clustering() {
        this(new ArrayList<Cluster<M>>());
    }

    public void addToplevelCluster(Cluster<M> clus) {
        this.toplevelclusters.add(clus);
        this.hierarchy.add(clus);
    }

    public void addChildCluster(Cluster<M> parent, Cluster<M> child) {
        this.hierarchy.add(parent, child);
    }

    public List<Cluster<M>> getToplevelClusters() {
        return this.toplevelclusters;
    }

    public Hierarchy<Cluster<M>> getClusterHierarchy() {
        return this.hierarchy;
    }

    public List<Cluster<M>> getAllClusters() {
        ArrayList<Cluster<M>> res = new ArrayList<Cluster<M>>(this.hierarchy.size());
        It iter = this.hierarchy.iterAll();
        while (iter.valid()) {
            res.add((Cluster)iter.get());
            iter.advance();
        }
        Collections.sort(res, Cluster.BY_NAME_SORTER);
        return res;
    }

    public It<Cluster<M>> iterToplevelClusters() {
        return new IterableIt(this.toplevelclusters);
    }

    public static List<Clustering<? extends Model>> getClusteringResults(Object r) {
        return (List)Metadata.hierarchyOf((Object)r).iterDescendantsSelf().filter(Clustering.class).collect(new ArrayList());
    }
}

