/*
 * Decompiled with CFR 0.152.
 */
package elki.data.model;

import elki.data.model.SimplePrototypeModel;
import elki.math.linearalgebra.pca.PCAFilteredResult;
import elki.result.textwriter.TextWriterStream;
import elki.utilities.io.FormatUtil;

public class CorrelationModel
extends SimplePrototypeModel<double[]> {
    private PCAFilteredResult pcaresult;

    public CorrelationModel(PCAFilteredResult pcaresult, double[] centroid) {
        super(centroid);
        this.pcaresult = pcaresult;
    }

    public PCAFilteredResult getPCAResult() {
        return this.pcaresult;
    }

    public void setPCAResult(PCAFilteredResult pcaresult) {
        this.pcaresult = pcaresult;
    }

    @Override
    public void writeToText(TextWriterStream out, String label) {
        if (label != null) {
            out.commentPrintLn((CharSequence)label);
        }
        out.commentPrintLn((CharSequence)("Model class: " + this.getClass().getName()));
        out.commentPrintLn((CharSequence)("Centroid: " + FormatUtil.format((double[])((double[])this.getPrototype()))));
        out.commentPrintLn((CharSequence)"Strong Eigenvectors:");
        String strong = FormatUtil.format((double[][])this.getPCAResult().getStrongEigenvectors());
        while (strong.endsWith("\n")) {
            strong = strong.substring(0, strong.length() - 1);
        }
        out.commentPrintLn((CharSequence)strong);
        out.commentPrintLn((CharSequence)"Weak Eigenvectors:");
        String weak = FormatUtil.format((double[][])this.getPCAResult().getWeakEigenvectors());
        while (weak.endsWith("\n")) {
            weak = weak.substring(0, weak.length() - 1);
        }
        out.commentPrintLn((CharSequence)weak);
        out.commentPrintLn((CharSequence)("Eigenvalues: " + FormatUtil.format((double[])this.getPCAResult().getEigenvalues())));
    }
}

