/*
 * Decompiled with CFR 0.152.
 */
package elki.data.model;

import elki.data.DoubleVector;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.data.model.MedoidModel;
import elki.data.model.Model;
import elki.data.model.PrototypeModel;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.math.linearalgebra.Centroid;
import elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import elki.utilities.datastructures.arraylike.NumberVectorAdapter;

public final class ModelUtil {
    private ModelUtil() {
    }

    public static <V extends NumberVector> V getPrototype(Model model, Relation<? extends V> relation, NumberVector.Factory<V> factory) {
        if (model instanceof MeanModel) {
            double[] p = ((MeanModel)model).getMean();
            return (V)factory.newNumberVector(p);
        }
        if (model instanceof MedoidModel) {
            NumberVector p = (NumberVector)relation.get((DBIDRef)((MedoidModel)model).getMedoid());
            if (factory.getRestrictionClass().isInstance(p)) {
                return (V)p;
            }
            return (V)factory.newNumberVector((Object)p, (NumberArrayAdapter)NumberVectorAdapter.STATIC);
        }
        if (model instanceof PrototypeModel) {
            Object p = ((PrototypeModel)model).getPrototype();
            if (factory.getRestrictionClass().isInstance(p)) {
                return (V)((NumberVector)p);
            }
            if (p instanceof NumberVector) {
                return (V)factory.newNumberVector((Object)((NumberVector)p), (NumberArrayAdapter)NumberVectorAdapter.STATIC);
            }
            return null;
        }
        return null;
    }

    public static NumberVector getPrototype(Model model, Relation<? extends NumberVector> relation) {
        if (model instanceof MeanModel) {
            return DoubleVector.wrap((double[])((MeanModel)model).getMean());
        }
        if (model instanceof MedoidModel) {
            return (NumberVector)relation.get((DBIDRef)((MedoidModel)model).getMedoid());
        }
        if (model instanceof PrototypeModel) {
            Object p = ((PrototypeModel)model).getPrototype();
            if (p instanceof NumberVector) {
                return (NumberVector)p;
            }
            return null;
        }
        return null;
    }

    public static <V extends NumberVector> V getPrototypeOrCentroid(Model model, Relation<? extends V> relation, DBIDs ids, NumberVector.Factory<V> factory) {
        assert (ids.size() > 0);
        V v = ModelUtil.getPrototype(model, relation, factory);
        return (V)(v != null ? v : factory.newNumberVector((NumberVector)Centroid.make(relation, (DBIDs)ids)));
    }

    public static NumberVector getPrototypeOrCentroid(Model model, Relation<? extends NumberVector> relation, DBIDs ids) {
        assert (ids.size() > 0);
        NumberVector v = ModelUtil.getPrototype(model, relation);
        return v != null ? v : Centroid.make(relation, (DBIDs)ids);
    }
}

