/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.LabelList;
import elki.data.model.ClusterModel;
import elki.data.model.Model;
import elki.data.type.TypeUtil;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.parser.AbstractStreamingParser;
import elki.datasource.parser.CSVReaderFormat;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.utilities.exceptions.AbortException;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ClusteringVectorParser
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(ClusteringVectorParser.class);
    int numterms;
    protected BundleMeta meta;
    BundleStreamSource.Event nextevent;
    Clustering<Model> curclu;
    LabelList curlbl;
    IntArrayList buf1 = new IntArrayList();
    DBIDRange range = null;
    ArrayList<String> lbl = new ArrayList();
    boolean haslbl;

    public ClusteringVectorParser(CSVReaderFormat format) {
        super(format);
    }

    public void initStream(InputStream in) {
        super.initStream(in);
        this.range = null;
        this.haslbl = false;
    }

    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event ret = this.nextevent;
            this.nextevent = null;
            return ret;
        }
        try {
            if (this.reader.nextLineExceptComments()) {
                boolean metaupdate;
                this.buf1.clear();
                this.lbl.clear();
                Int2IntOpenHashMap csize = new Int2IntOpenHashMap();
                String name = null;
                while (this.tokenizer.valid()) {
                    block15: {
                        try {
                            int cnum = this.tokenizer.getIntBase10();
                            this.buf1.add(cnum);
                            csize.addTo(cnum, 1);
                        }
                        catch (NumberFormatException e) {
                            String label = this.tokenizer.getSubstring();
                            this.lbl.add(label);
                            if (name != null) break block15;
                            name = label;
                        }
                    }
                    this.tokenizer.advance();
                }
                if (name == null) {
                    name = "Cluster";
                }
                boolean bl = metaupdate = this.range == null;
                if (this.range == null) {
                    this.range = DBIDUtil.generateStaticDBIDRange((int)this.buf1.size());
                }
                if (this.buf1.size() != this.range.size()) {
                    throw new AbortException("Clusterings do not contain the same number of elements!");
                }
                Int2ObjectOpenHashMap clusters = new Int2ObjectOpenHashMap(csize.size());
                this.curclu = new Clustering();
                Metadata.of(this.curclu).setLongName(name);
                ObjectIterator iter = csize.int2IntEntrySet().fastIterator();
                while (iter.hasNext()) {
                    Int2IntMap.Entry entry = (Int2IntMap.Entry)iter.next();
                    if (entry.getIntValue() <= 0) continue;
                    clusters.put(entry.getIntKey(), (Object)DBIDUtil.newArray((int)entry.getIntValue()));
                }
                iter = this.range.iter();
                for (int i = 0; i < this.buf1.size(); ++i) {
                    ((ModifiableDBIDs)clusters.get(this.buf1.getInt(i))).add((DBIDRef)iter.seek(i));
                }
                for (ModifiableDBIDs cids : clusters.values()) {
                    this.curclu.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)cids, ClusterModel.CLUSTER));
                }
                if (!this.haslbl && !this.lbl.isEmpty()) {
                    this.haslbl = true;
                    metaupdate = true;
                }
                this.curlbl = LabelList.make(this.lbl);
                if (metaupdate) {
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                return BundleStreamSource.Event.NEXT_OBJECT;
            }
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    public Object data(int rnum) {
        if (rnum == 0) {
            return this.curclu;
        }
        if (rnum == 1) {
            return this.curlbl;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.meta = new BundleMeta(this.haslbl ? 2 : 1);
            this.meta.add(Clustering.TYPE);
            if (this.haslbl) {
                this.meta.add((Object)TypeUtil.LABELLIST);
            }
        }
        return this.meta;
    }

    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractStreamingParser.Par {
        public ClusteringVectorParser make() {
            return new ClusteringVectorParser(this.format);
        }
    }
}

