/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.evaluation.clustering.ClusterContingencyTable;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;

@References(value={@Reference(authors="A. Bagga, B. Baldwin", title="Entity-based cross-document coreferencing using the Vector Space Model", booktitle="Proc. 17th Int. Conf. on Computational Linguistics (COLING '98)", url="https://doi.org/10.3115/980451.980859", bibkey="doi:10.3115/980451.980859"), @Reference(authors="E. Amig\u00f3, J. Gonzalo, J. Artiles, F. Verdejo", title="A comparison of extrinsic clustering evaluation metrics based on formal constraints", booktitle="Information Retrieval 12(4)", url="https://doi.org/10.1007/s10791-008-9066-8", bibkey="DBLP:journals/ir/AmigoGAV09")})
public class BCubed {
    protected double bCubedPrecision = -1.0;
    protected double bCubedRecall = -1.0;

    protected BCubed(ClusterContingencyTable table) {
        double aggPrec = 0.0;
        double aggRec = 0.0;
        int selfpair = table.selfPairing ? 0 : 1;
        for (int i1 = 0; i1 < table.size1; ++i1) {
            int[] sumrow = table.contingency[i1];
            for (int i2 = 0; i2 < table.size2; ++i2) {
                int c = sumrow[i2];
                if (c <= selfpair) continue;
                aggPrec += (double)(c * (c - selfpair)) / (double)(table.contingency[table.size1][i2] - selfpair);
                aggRec += (double)(c * (c - selfpair)) / (double)(sumrow[table.size2] - selfpair);
            }
        }
        int total = table.contingency[table.size1][table.size2];
        this.bCubedPrecision = aggPrec / (double)total;
        this.bCubedRecall = aggRec / (double)total;
    }

    public double precision() {
        return this.bCubedPrecision;
    }

    public double recall() {
        return this.bCubedRecall;
    }

    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.bCubedPrecision, this.bCubedRecall);
    }
}

