/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.SetDBIDs;
import elki.evaluation.clustering.BCubed;
import elki.evaluation.clustering.EditDistance;
import elki.evaluation.clustering.Entropy;
import elki.evaluation.clustering.MaximumMatchingAccuracy;
import elki.evaluation.clustering.PairCounting;
import elki.evaluation.clustering.PairSetsIndex;
import elki.evaluation.clustering.SetMatchingPurity;
import elki.math.MeanVariance;
import elki.utilities.datastructures.BitsUtil;
import java.util.Iterator;
import java.util.List;

public class ClusterContingencyTable {
    protected boolean breakNoiseClusters = false;
    protected boolean selfPairing = true;
    protected int size1 = -1;
    protected int size2 = -1;
    protected int[][] contingency = null;
    protected long[] noise1 = null;
    protected long[] noise2 = null;
    protected PairCounting paircount = null;
    protected Entropy entropy = null;
    protected SetMatchingPurity smp = null;
    protected MaximumMatchingAccuracy mmacc = null;
    protected PairSetsIndex psi = null;
    protected EditDistance edit = null;
    protected BCubed bcubed = null;

    public ClusterContingencyTable(boolean selfPairing, boolean breakNoiseClusters, Clustering<?> result1, Clustering<?> result2) {
        this.selfPairing = selfPairing;
        this.breakNoiseClusters = breakNoiseClusters;
        List<Cluster<?>> cs1 = result1.getAllClusters();
        List<Cluster<?>> cs2 = result2.getAllClusters();
        this.size1 = cs1.size();
        this.size2 = cs2.size();
        this.contingency = new int[this.size1 + 2][this.size2 + 2];
        this.noise1 = BitsUtil.zero((int)this.size1);
        this.noise2 = BitsUtil.zero((int)this.size2);
        Iterator<Cluster<?>> it2 = cs2.iterator();
        int i2 = 0;
        while (it2.hasNext()) {
            Cluster<?> c2 = it2.next();
            if (c2.isNoise()) {
                BitsUtil.setI((long[])this.noise2, (int)i2);
            }
            this.contingency[this.size1 + 1][i2] = c2.size();
            int[] nArray = this.contingency[this.size1 + 1];
            int n = this.size2;
            nArray[n] = nArray[n] + c2.size();
            ++i2;
        }
        Iterator<Cluster<?>> it1 = cs1.iterator();
        int i1 = 0;
        while (it1.hasNext()) {
            Cluster<?> c1 = it1.next();
            if (c1.isNoise()) {
                BitsUtil.setI((long[])this.noise1, (int)i1);
            }
            SetDBIDs ids = DBIDUtil.ensureSet((DBIDs)c1.getIDs());
            this.contingency[i1][this.size2 + 1] = c1.size();
            int[] nArray = this.contingency[this.size1];
            int n = this.size2 + 1;
            nArray[n] = nArray[n] + c1.size();
            Iterator<Cluster<?>> it22 = cs2.iterator();
            int i22 = 0;
            while (it22.hasNext()) {
                int count;
                Cluster<?> c2 = it22.next();
                this.contingency[i1][i22] = count = DBIDUtil.intersectionSize((DBIDs)ids, (DBIDs)c2.getIDs());
                int[] nArray2 = this.contingency[i1];
                int n2 = this.size2;
                nArray2[n2] = nArray2[n2] + count;
                int[] nArray3 = this.contingency[this.size1];
                int n3 = i22++;
                nArray3[n3] = nArray3[n3] + count;
                int[] nArray4 = this.contingency[this.size1];
                int n4 = this.size2;
                nArray4[n4] = nArray4[n4] + count;
            }
            ++i1;
        }
    }

    public boolean isStrictPartitioning() {
        int expected = this.contingency[this.size1][this.size2];
        return this.contingency[this.size1][this.size2 + 1] == expected && this.contingency[this.size1 + 1][this.size2] == expected;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.size1 * this.size2 * 10 + 10);
        if (this.contingency != null) {
            for (int i1 = 0; i1 <= this.size1; ++i1) {
                for (int i2 = 0; i2 <= this.size2; ++i2) {
                    buf.append(this.contingency[i1][i2]).append(i2 < this.size2 ? " " : "| ");
                }
                buf.append(i1 < this.size1 ? "\n" : "------\n");
            }
        }
        return buf.toString();
    }

    public PairCounting getPaircount() {
        return this.paircount != null ? this.paircount : (this.paircount = new PairCounting(this));
    }

    public Entropy getEntropy() {
        return this.entropy != null ? this.entropy : (this.entropy = new Entropy(this));
    }

    public EditDistance getEdit() {
        return this.edit != null ? this.edit : (this.edit = new EditDistance(this));
    }

    public BCubed getBCubed() {
        return this.bcubed != null ? this.bcubed : (this.bcubed = new BCubed(this));
    }

    public SetMatchingPurity getSetMatchingPurity() {
        return this.smp != null ? this.smp : (this.smp = new SetMatchingPurity(this));
    }

    public MaximumMatchingAccuracy getMaximumMatchingAccuracy() {
        return this.mmacc != null ? this.mmacc : (this.mmacc = new MaximumMatchingAccuracy(this));
    }

    public PairSetsIndex getPairSetsIndex() {
        return this.psi != null ? this.psi : (this.psi = new PairSetsIndex(this));
    }

    public MeanVariance averageSymmetricGini() {
        double rel;
        double cs;
        double purity;
        MeanVariance mv = new MeanVariance();
        for (int i1 = 0; i1 < this.size1; ++i1) {
            purity = 0.0;
            if (this.contingency[i1][this.size2] <= 0) continue;
            cs = this.contingency[i1][this.size2];
            for (int i2 = 0; i2 < this.size2; ++i2) {
                rel = (double)this.contingency[i1][i2] / cs;
                purity += rel * rel;
            }
            mv.put(purity, cs);
        }
        for (int i2 = 0; i2 < this.size2; ++i2) {
            purity = 0.0;
            if (this.contingency[this.size1][i2] <= 0) continue;
            cs = this.contingency[this.size1][i2];
            for (int i1 = 0; i1 < this.size1; ++i1) {
                rel = (double)this.contingency[i1][i2] / cs;
                purity += rel * rel;
            }
            mv.put(purity, cs);
        }
        return mv;
    }

    public MeanVariance adjustedSymmetricGini() {
        double e;
        double rel;
        double cs;
        double exp;
        double purity;
        MeanVariance mv = new MeanVariance();
        double total = this.contingency[this.size1][this.size2];
        for (int i1 = 0; i1 < this.size1; ++i1) {
            purity = 0.0;
            exp = 0.0;
            if (this.contingency[i1][this.size2] <= 0) continue;
            cs = this.contingency[i1][this.size2];
            for (int i2 = 0; i2 < this.size2; ++i2) {
                rel = (double)this.contingency[i1][i2] / cs;
                purity += rel * rel;
                e = (double)this.contingency[this.size1][i2] / total;
                exp += e * e;
            }
            mv.put((purity - exp) / (1.0 - exp), cs);
        }
        for (int i2 = 0; i2 < this.size2; ++i2) {
            purity = 0.0;
            exp = 0.0;
            if (this.contingency[this.size1][i2] <= 0) continue;
            cs = this.contingency[this.size1][i2];
            for (int i1 = 0; i1 < this.size1; ++i1) {
                rel = (double)this.contingency[i1][i2] / cs;
                purity += rel * rel;
                e = (double)this.contingency[i1][this.size2] / total;
                exp += e * e;
            }
            mv.put((purity - exp) / (1.0 - exp), cs);
        }
        return mv;
    }

    public static final class Util {
        private Util() {
        }

        public static double fMeasure(double precision, double recall, double beta) {
            double beta2 = beta * beta;
            return (1.0 + beta2) * precision * recall / (beta2 * precision + recall);
        }

        public static double f1Measure(double precision, double recall) {
            return 2.0 * precision * recall / (precision + recall);
        }
    }
}

