/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.evaluation.clustering.ClusterContingencyTable;
import elki.utilities.documentation.Reference;

@Reference(authors="P. Pantel, D. Lin", title="Document clustering with committees", booktitle="Proc. 25th ACM SIGIR Conf. on Research and Development in Information Retrieval", url="https://doi.org/10.1145/564376.564412", bibkey="DBLP:conf/sigir/PantelL02")
public class EditDistance {
    int editFirst = -1;
    int editSecond = -1;
    int editOperationsBaseline;

    protected EditDistance(ClusterContingencyTable table) {
        int j;
        int largestLabelSet;
        int csize;
        int i;
        int[][] contingency = table.contingency;
        int r = table.size1;
        int c = table.size2;
        int ed1 = 0;
        int ed2 = 0;
        for (i = 0; i < c; ++i) {
            csize = contingency[r][i];
            if (csize <= 0) continue;
            largestLabelSet = 0;
            for (j = 0; j < r; ++j) {
                largestLabelSet = Math.max(largestLabelSet, contingency[j][i]);
            }
            ed1 += 1 + csize - largestLabelSet;
        }
        for (i = 0; i < r; ++i) {
            csize = contingency[i][c];
            if (csize <= 0) continue;
            largestLabelSet = 0;
            for (j = 0; j < c; ++j) {
                largestLabelSet = Math.max(largestLabelSet, contingency[i][j]);
            }
            ed2 += 1 + csize - largestLabelSet;
        }
        this.editFirst = ed1;
        this.editSecond = ed2;
        this.editOperationsBaseline = contingency[r][c];
    }

    public int editOperationsBaseline() {
        return this.editOperationsBaseline;
    }

    public int editOperationsFirst() {
        return this.editFirst;
    }

    public int editOperationsSecond() {
        return this.editSecond;
    }

    public double editDistanceFirst() {
        return 1.0 - (double)this.editOperationsFirst() / (double)this.editOperationsBaseline();
    }

    public double editDistanceSecond() {
        return 1.0 - (double)this.editOperationsSecond() / (double)this.editOperationsBaseline();
    }

    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.editDistanceFirst(), this.editDistanceSecond());
    }
}

