/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.evaluation.clustering.ClusterContingencyTable;
import elki.logging.LoggingUtil;
import elki.math.statistics.distribution.GammaDistribution;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import net.jafama.FastMath;

@References(value={@Reference(authors="M. Meil\u0103", title="Comparing clusterings by the variation of information", booktitle="Learning theory and kernel machines", url="https://doi.org/10.1007/978-3-540-45167-9_14", bibkey="DBLP:conf/colt/Meila03"), @Reference(authors="X. V. Nguyen, J. Epps, J. Bailey", title="Information theoretic measures for clusterings comparison: is a correction for chance necessary?", booktitle="Proc. 26th Ann. Int. Conf. on Machine Learning (ICML '09)", url="https://doi.org/10.1145/1553374.1553511", bibkey="DBLP:conf/icml/NguyenEB09"), @Reference(authors="S. Romano, J. Bailey, X. V. Nguyen, K. Verspoor", title="Standardized Mutual Information for Clustering Comparisons: One Step Further in Adjustment for Chance", booktitle="Proc. 31th Int. Conf. on Machine Learning (ICML 2014)", url="http://proceedings.mlr.press/v32/romano14.html", bibkey="DBLP:conf/icml/RomanoBNV14")})
public class Entropy {
    protected double entropyFirst;
    protected double entropySecond;
    protected double entropyJoint;
    protected double mutualInformation;
    protected double variationOfInformation;
    protected double expectedMutualInformation;
    protected double vibound;

    protected Entropy(ClusterContingencyTable table) {
        int r = table.size1;
        int c = table.size2;
        int[][] contingency = table.contingency;
        int n = contingency[r][c];
        if (table.contingency[table.size1][table.size2 + 1] != n || table.contingency[table.size1 + 1][table.size2] != n) {
            LoggingUtil.warning((String)("Entropy measure are not well defined for overlapping and incomplete clusterings. The number of elements are: " + table.contingency[table.size1][table.size2 + 1] + " != " + table.contingency[table.size1 + 1][table.size2] + " elements."));
        }
        double byn = 1.0 / (double)n;
        double mlogn = -FastMath.log((double)n);
        if (n <= 10000) {
            int m = Entropy.maxClusterSize(contingency, r, c);
            double[] logs = new double[m];
            this.entropyFirst = Entropy.computeEntropyFirst(contingency, r, c, byn, mlogn, logs);
            this.entropySecond = Entropy.computeEntropySecond(contingency, r, c, byn, mlogn, logs);
            this.computeMIFull(contingency, r, c, n, m, byn, mlogn, logs);
        } else {
            this.computeMILarge(contingency, r, c, byn, mlogn);
        }
    }

    private void computeMILarge(int[][] contingency, int r, int c, double byn, double mlogn) {
        int[] lastrow = contingency[r];
        double[] logs = new double[14];
        double[] mlogbn = new double[c];
        double ent1 = 0.0;
        double ent2 = 0.0;
        double joint = 0.0;
        double mi = 0.0;
        double vi = 0.0;
        for (int j = 0; j < c; ++j) {
            int v = lastrow[j];
            if (v <= 0) continue;
            mlogbn[j] = -Entropy.log(v, logs) - mlogn;
            ent2 += (double)v * byn * mlogbn[j];
        }
        for (int i = 0; i < r; ++i) {
            int[] rowi = contingency[i];
            int an = rowi[c];
            if (an <= 0) continue;
            double mlogain = -Entropy.log(an, logs) - mlogn;
            ent1 += (double)an * byn * mlogain;
            for (int j = 0; j < c; ++j) {
                int vij = rowi[j];
                double mlogbjn = mlogbn[j];
                if (vij <= 0) continue;
                double p = (double)vij * byn;
                double mlogp = -Entropy.log(vij, logs) - mlogn;
                joint += p * mlogp;
                mi += p * (mlogain + mlogbjn - mlogp);
                vi += p * (mlogp - mlogain + mlogp - mlogbjn);
            }
        }
        this.entropyFirst = ent1;
        this.entropySecond = ent2;
        this.entropyJoint = joint;
        this.mutualInformation = mi;
        this.variationOfInformation = vi;
        this.expectedMutualInformation = 0.0;
        this.vibound = Math.min(-mlogn, 2.0 * FastMath.log((double)Math.max(r, c)));
    }

    private void computeMIFull(int[][] contingency, int r, int c, int n, int m, double byn, double mlogn, double[] logs) {
        double[] lfacs = new double[Math.max(n, 1)];
        double tmp = 0.0;
        int e = Math.max(n - m, 2);
        for (int i = 2; i <= e; ++i) {
            lfacs[i - 2] = tmp += Entropy.log(i, logs);
        }
        int[] lastrow = contingency[r];
        double joint = 0.0;
        double mi = 0.0;
        double vi = 0.0;
        double emi = 0.0;
        for (int i = 0; i < r; ++i) {
            int[] rowi = contingency[i];
            int ai = rowi[c];
            double mlogain = -Entropy.log(ai, logs) - mlogn;
            double lfacai = Entropy.lfac(ai, lfacs);
            double lfacNmai = Entropy.lfac(n - ai, lfacs);
            for (int j = 0; j < c; ++j) {
                int end;
                int start;
                int bj = lastrow[j];
                int vij = rowi[j];
                double mlogbjn = -Entropy.log(bj, logs) - mlogn;
                if (vij > 0) {
                    double p = (double)vij * byn;
                    double mlogp = -Entropy.log(vij, logs) - mlogn;
                    joint += p * mlogp;
                    mi += p * (mlogain + mlogbjn - mlogp);
                    vi += p * (mlogp - mlogain + mlogp - mlogbjn);
                }
                if ((start = Math.max(ai + bj - n, 1)) > (end = Math.min(ai, bj))) continue;
                double t1 = mlogain + mlogbjn + mlogn;
                double t2 = FastMath.exp((double)(lfacai + Entropy.lfac(bj, lfacs) + lfacNmai + Entropy.lfac(n - bj, lfacs) - Entropy.lfac(n, lfacs) - Entropy.lfac(start, lfacs) - Entropy.lfac(ai - start, lfacs) - Entropy.lfac(bj - start, lfacs) - Entropy.lfac(n - ai - bj + start, lfacs)));
                emi += (double)start * byn * (t1 + Entropy.log(start, logs)) * t2;
                for (int nij = start + 1; nij <= end && !((t2 *= ((double)(ai - nij) + 1.0) * ((double)(bj - nij) + 1.0) / (double)(nij * (n - ai - bj + nij))) < 0.0); ++nij) {
                    emi += (double)nij * byn * (t1 + Entropy.log(nij, logs)) * t2;
                }
            }
        }
        this.entropyJoint = joint;
        this.mutualInformation = mi;
        this.variationOfInformation = vi;
        this.expectedMutualInformation = emi;
        this.vibound = Math.min(-mlogn, 2.0 * FastMath.log((double)Math.max(r, c)));
    }

    private static double log(int i, double[] logs) {
        if (i <= 1) {
            return 0.0;
        }
        if (i - 2 >= logs.length) {
            return FastMath.log((double)i);
        }
        double v = logs[i - 2];
        return v > 0.0 ? v : (logs[i - 2] = FastMath.log((double)i));
    }

    private static double lfac(int i, double[] lfac) {
        if (i <= 1) {
            return 0.0;
        }
        double v = lfac[i - 2];
        if (v > 0.0) {
            return v;
        }
        double p = lfac[i - 3];
        double d = p > 0.0 ? p + FastMath.log((double)i) : GammaDistribution.logGamma((double)((double)i + 1.0));
        lfac[i - 2] = d;
        return d;
    }

    private static int maxClusterSize(int[][] contingency, int r, int c) {
        int v;
        int maxc = 0;
        int[] lastrow = contingency[r];
        for (int j = 0; j < c; ++j) {
            v = lastrow[j];
            maxc = maxc > v ? maxc : v;
        }
        for (int i = 0; i < r; ++i) {
            v = contingency[i][c];
            maxc = maxc > v ? maxc : v;
        }
        return maxc;
    }

    private static double computeEntropyFirst(int[][] contingency, int r, int c, double byn, double mlogn, double[] logs) {
        double entropyFirst = 0.0;
        for (int i = 0; i < r; ++i) {
            int v = contingency[i][c];
            if (v <= 0) continue;
            entropyFirst += (double)v * byn * (-Entropy.log(v, logs) - mlogn);
        }
        return entropyFirst;
    }

    private static double computeEntropySecond(int[][] contingency, int r, int c, double byn, double mlogn, double[] logs) {
        double entropySecond = 0.0;
        int[] lastrow = contingency[r];
        for (int j = 0; j < c; ++j) {
            int v = lastrow[j];
            if (v <= 0) continue;
            entropySecond += (double)v * byn * (-Entropy.log(v, logs) - mlogn);
        }
        return entropySecond;
    }

    public double entropyFirst() {
        return this.entropyFirst;
    }

    public double entropySecond() {
        return this.entropySecond;
    }

    public double entropyJoint() {
        return this.entropyJoint;
    }

    public double conditionalEntropyFirst() {
        return this.entropyJoint - this.entropySecond;
    }

    public double conditionalEntropySecond() {
        return this.entropyJoint - this.entropyFirst;
    }

    public double entropyPowers() {
        return 2.0 * this.entropyJoint / (this.entropyFirst + this.entropySecond) - 1.0;
    }

    public double mutualInformation() {
        return this.mutualInformation;
    }

    public double upperBoundMI() {
        return Math.min(this.entropyFirst, this.entropySecond);
    }

    @Reference(authors="Y. Y. Yao", title="Information-Theoretic Measures for Knowledge Discovery and Data Mining", booktitle="Entropy Measures, Maximum Entropy Principle and Emerging Applications", url="https://doi.org/10.1007/978-3-540-36212-8_6", bibkey="doi:10.1007/978-3-540-36212-8_6")
    public double jointNMI() {
        return this.entropyJoint == 0.0 ? 0.0 : this.mutualInformation / this.entropyJoint;
    }

    @Reference(authors="Tarald O. Kv\u00e5lseth", title="Entropy and Correlation: Some Comments", booktitle="IEEE Trans. Systems, Man, and Cybernetics 17(3)", url="https://doi.org/10.1109/TSMC.1987.4309069", bibkey="DBLP:journals/tsmc/Kvalseth87")
    public double minNMI() {
        return this.mutualInformation / Math.min(this.entropyFirst, this.entropySecond);
    }

    @Reference(authors="Tarald O. Kv\u00e5lseth", title="Entropy and Correlation: Some Comments", booktitle="IEEE Trans. Systems, Man, and Cybernetics 17(3)", url="https://doi.org/10.1109/TSMC.1987.4309069", bibkey="DBLP:journals/tsmc/Kvalseth87")
    public double maxNMI() {
        return this.mutualInformation / Math.max(this.entropyFirst, this.entropySecond);
    }

    @References(value={@Reference(authors="Tarald O. Kv\u00e5lseth", title="Entropy and Correlation: Some Comments", booktitle="IEEE Trans. Systems, Man, and Cybernetics 17(3)", url="https://doi.org/10.1109/TSMC.1987.4309069", bibkey="DBLP:journals/tsmc/Kvalseth87"), @Reference(authors="A. Rosenberg, J. Hirschberg", title="V-Measure: A Conditional Entropy-Based External Cluster Evaluation Measure", booktitle="EMNLP-CoNLL 2007", url="https://www.aclweb.org/anthology/D07-1043/", bibkey="DBLP:conf/emnlp/RosenbergH07")})
    public double arithmeticNMI() {
        return 2.0 * this.mutualInformation / (this.entropyFirst + this.entropySecond);
    }

    @Reference(authors="A. Strehl, J. Ghosh", title="Cluster Ensembles -A Knowledge Reuse Framework for Combining Multiple Partitions", booktitle="J. Mach. Learn. Res. 3", url="http://jmlr.org/papers/v3/strehl02a.html", bibkey="DBLP:journals/jmlr/StrehlG02")
    public double geometricNMI() {
        return this.entropyFirst * this.entropySecond <= 0.0 ? this.mutualInformation : this.mutualInformation / Math.sqrt(this.entropyFirst * this.entropySecond);
    }

    public double variationOfInformation() {
        return this.variationOfInformation;
    }

    public double upperBoundVI() {
        return this.vibound;
    }

    public double normalizedVariationOfInformation() {
        return 1.0 - this.mutualInformation / this.entropyJoint;
    }

    public double normalizedInformationDistance() {
        return 1.0 - this.mutualInformation / Math.max(this.entropyFirst, this.entropySecond);
    }

    public double expectedMutualInformation() {
        return this.expectedMutualInformation;
    }

    public double adjustedJointMI() {
        return (this.mutualInformation - this.expectedMutualInformation) / (this.entropyJoint - this.expectedMutualInformation);
    }

    public double adjustedArithmeticMI() {
        return (this.mutualInformation - this.expectedMutualInformation) / (0.5 * (this.entropyFirst + this.entropySecond) - this.expectedMutualInformation);
    }

    public double adjustedGeometricMI() {
        return this.entropyFirst * this.entropySecond <= 0.0 ? this.mutualInformation - this.expectedMutualInformation : (this.mutualInformation - this.expectedMutualInformation) / (Math.sqrt(this.entropyFirst * this.entropySecond) - this.expectedMutualInformation);
    }

    public double adjustedMinMI() {
        return (this.mutualInformation - this.expectedMutualInformation) / (Math.min(this.entropyFirst, this.entropySecond) - this.expectedMutualInformation);
    }

    public double adjustedMaxMI() {
        return (this.mutualInformation - this.expectedMutualInformation) / (Math.max(this.entropyFirst, this.entropySecond) - this.expectedMutualInformation);
    }
}

