/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.trivial.ByLabelOrAllInOneClustering;
import elki.clustering.trivial.ReferenceClustering;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.database.Database;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.BCubed;
import elki.evaluation.clustering.ClusterContingencyTable;
import elki.evaluation.clustering.EditDistance;
import elki.evaluation.clustering.Entropy;
import elki.evaluation.clustering.MaximumMatchingAccuracy;
import elki.evaluation.clustering.PairCounting;
import elki.evaluation.clustering.PairSetsIndex;
import elki.evaluation.clustering.SetMatchingPurity;
import elki.evaluation.scores.ScoreEvaluation;
import elki.evaluation.scores.adapter.DistanceResultAdapter;
import elki.logging.Logging;
import elki.math.MeanVariance;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

public class EvaluateClustering
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateClustering.class);
    private ClusteringAlgorithm<?> referencealg;
    private boolean noiseSpecialHandling;
    private boolean selfPairing;

    public EvaluateClustering(ClusteringAlgorithm<?> referencealg, boolean noiseSpecialHandling, boolean selfPairing) {
        this.referencealg = referencealg;
        this.noiseSpecialHandling = noiseSpecialHandling;
        this.selfPairing = selfPairing;
    }

    public static double evaluateRanking(ScoreEvaluation eval, Cluster<?> clus, DoubleDBIDList ranking) {
        return eval.evaluate((ScoreEvaluation.Adapter)new DistanceResultAdapter((DBIDs)DBIDUtil.ensureSet((DBIDs)clus.getIDs()), ranking.iter(), ranking.size()));
    }

    public void processNewResult(Object newResult) {
        if (newResult instanceof Clustering && this.isReferenceResult((Clustering)newResult)) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)newResult);
        List<Clustering<Model>> crs = Clustering.getClusteringResults(newResult);
        if (crs == null || crs.isEmpty()) {
            return;
        }
        Clustering refc = null;
        ArrayList cs = ResultUtil.filterResults((Object)db, Clustering.class);
        for (Clustering test : cs) {
            if (!this.isReferenceResult(test)) continue;
            refc = test;
            break;
        }
        if (refc == null) {
            cs = ResultUtil.filterResults((Object)newResult, Clustering.class);
            for (Clustering test : cs) {
                if (!this.isReferenceResult(test)) continue;
                refc = test;
                break;
            }
        }
        if (refc == null) {
            LOG.debug((CharSequence)"Generating a new reference clustering.");
            Object refres = this.referencealg.autorun(db);
            List<Clustering<Model>> refcrs = Clustering.getClusteringResults(refres);
            if (refcrs.isEmpty()) {
                LOG.warning((CharSequence)"Reference algorithm did not return a clustering result!");
                return;
            }
            if (refcrs.size() > 1) {
                LOG.warning((CharSequence)"Reference algorithm returned more than one result!");
            }
            refc = refcrs.get(0);
        } else {
            LOG.debug((CharSequence)("Using existing clustering: " + Metadata.of((Object)refc).getLongName()));
        }
        for (Clustering<Model> c : crs) {
            if (c == refc) continue;
            this.evaluteResult(db, c, refc);
        }
    }

    protected void evaluteResult(Database db, Clustering<?> c, Clustering<?> refc) {
        ClusterContingencyTable contmat = new ClusterContingencyTable(this.selfPairing, this.noiseSpecialHandling, refc, c);
        ScoreResult sr = new ScoreResult(contmat);
        sr.addHeader(Metadata.of(c).getLongName());
        Metadata.hierarchyOf(c).addChild((Object)sr);
    }

    private boolean isReferenceResult(Clustering<?> t) {
        return t instanceof ReferenceClustering;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID REFERENCE_ID = new OptionID("paircounting.reference", "Reference clustering to compare with. Defaults to a by-label clustering.");
        public static final OptionID NOISE_ID = new OptionID("paircounting.noisespecial", "Use special handling for noise clusters.");
        public static final OptionID SELFPAIR_ID = new OptionID("paircounting.selfpair", "Enable self-pairing for cluster comparison.");
        private ClusteringAlgorithm<?> referencealg;
        private boolean noiseSpecialHandling;
        private boolean selfPairing;

        public void configure(Parameterization config) {
            new ObjectParameter(REFERENCE_ID, ClusteringAlgorithm.class, ByLabelOrAllInOneClustering.class).grab(config, x -> {
                this.referencealg = x;
            });
            new Flag(NOISE_ID).grab(config, x -> {
                this.noiseSpecialHandling = x;
            });
            new Flag(SELFPAIR_ID).grab(config, x -> {
                this.selfPairing = x;
            });
        }

        public EvaluateClustering make() {
            return new EvaluateClustering(this.referencealg, this.noiseSpecialHandling, !this.selfPairing);
        }
    }

    public static class ScoreResult
    extends EvaluationResult {
        protected ClusterContingencyTable contmat;

        public ScoreResult(ClusterContingencyTable contmat) {
            Metadata.of((Object)((Object)this)).setLongName("Clustering Evaluation");
            this.contmat = contmat;
            PairCounting paircount = contmat.getPaircount();
            this.newGroup("Pair counting").addMeasure("Jaccard", paircount.jaccard(), 0.0, 1.0, false).addMeasure("F1-Measure", paircount.f1Measure(), 0.0, 1.0, false).addMeasure("Precision", paircount.precision(), 0.0, 1.0, false).addMeasure("Recall", paircount.recall(), 0.0, 1.0, false).addMeasure("Rand", paircount.randIndex(), 0.0, 1.0, false).addMeasure("ARI", paircount.adjustedRandIndex(), 0.0, 1.0, false).addMeasure("Fowlkes-Mallows", paircount.fowlkesMallows(), 0.0, 1.0, false);
            Entropy entropy = contmat.getEntropy();
            EvaluationResult.MeasurementGroup g = this.newGroup("Entropy based").addMeasure("MI", entropy.mutualInformation(), 0.0, entropy.upperBoundMI(), false).addMeasure("VI", entropy.variationOfInformation(), 0.0, entropy.upperBoundVI(), true).addMeasure("Homogeneity", entropy.mutualInformation() / entropy.entropyFirst(), 0.0, 1.0, false).addMeasure("Completeness", entropy.mutualInformation() / entropy.entropySecond(), 0.0, 1.0, false).addMeasure("Arithmetic NMI", entropy.arithmeticNMI(), 0.0, 1.0, false).addMeasure("Geometric NMI", entropy.geometricNMI(), 0.0, 1.0, false).addMeasure("Joint NMI", entropy.jointNMI(), 0.0, 1.0, false).addMeasure("NVI", entropy.normalizedVariationOfInformation(), 0.0, 1.0, true).addMeasure("NID", entropy.normalizedInformationDistance(), 0.0, 1.0, true);
            if (entropy.expectedMutualInformation() > 0.0) {
                g.addMeasure("Arithmetic AMI", entropy.adjustedArithmeticMI(), 0.0, 1.0, false).addMeasure("Geometric AMI", entropy.adjustedGeometricMI(), 0.0, 1.0, false).addMeasure("Joint AMI", entropy.adjustedJointMI(), 0.0, 1.0, false);
            }
            BCubed bcubed = contmat.getBCubed();
            this.newGroup("B3").addMeasure("F1-Measure", bcubed.f1Measure(), 0.0, 1.0, false).addMeasure("Precision", bcubed.precision(), 0.0, 1.0, false).addMeasure("Recall", bcubed.recall(), 0.0, 1.0, false);
            MaximumMatchingAccuracy kmwacc = contmat.getMaximumMatchingAccuracy();
            SetMatchingPurity setm = contmat.getSetMatchingPurity();
            PairSetsIndex psi = contmat.getPairSetsIndex();
            this.newGroup("Set Matching").addMeasure("Maximum Accuracy", kmwacc.getAccuracy(), 0.0, 1.0, false).addMeasure("Purity", setm.purity(), 0.0, 1.0, false).addMeasure("Inverse Purity", setm.inversePurity(), 0.0, 1.0, false).addMeasure("F1-Measure", setm.f1Measure(), 0.0, 1.0, false).addMeasure("Pair Sets Index", psi.psi, 0.0, 1.0, false);
            EditDistance edit = contmat.getEdit();
            this.newGroup("Edit Distance").addMeasure("F1-Measure", edit.f1Measure(), 0.0, 1.0, false).addMeasure("Precision", edit.editDistanceFirst(), 0.0, 1.0, false).addMeasure("Recall", edit.editDistanceSecond(), 0.0, 1.0, false);
            MeanVariance gini = contmat.averageSymmetricGini();
            MeanVariance agini = contmat.adjustedSymmetricGini();
            this.newGroup("Gini").addMeasure("Mean", gini.getMean(), 0.0, 1.0, false).addMeasure("Adjusted Mean", agini.getMean(), 0.0, 1.0, false);
        }

        public ClusterContingencyTable getContingencyTable() {
            return this.contmat;
        }

        public boolean visualizeSingleton() {
            return true;
        }
    }
}

