/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.evaluation.Evaluator;
import elki.logging.Logging;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.result.Metadata;
import elki.utilities.datastructures.hierarchy.Hierarchy;
import elki.utilities.datastructures.iterator.It;
import java.util.List;

public class LogClusterSizes
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(LogClusterSizes.class);
    public static final String PREFIX = LogClusterSizes.class.getName() + ".";

    public static <C extends Model> void logClusterSizes(Clustering<C> c) {
        if (!LOG.isStatistics()) {
            return;
        }
        List<Cluster<C>> clusters = c.getAllClusters();
        int numc = clusters.size();
        LOG.statistics((Statistic)new StringStatistic(PREFIX + "name", Metadata.of(c).getLongName()));
        LOG.statistics((Statistic)new LongStatistic(PREFIX + "clusters", (long)numc));
        Hierarchy<Cluster<C>> h = c.getClusterHierarchy();
        int cnum = 0;
        for (Cluster<C> clu : clusters) {
            String p = PREFIX + "cluster-" + cnum + ".";
            if (clu.getName() != null) {
                LOG.statistics((Statistic)new StringStatistic(p + "name", clu.getName()));
            }
            LOG.statistics((Statistic)new LongStatistic(p + "size", (long)clu.size()));
            if (clu.isNoise()) {
                LOG.statistics((Statistic)new StringStatistic(p + "noise", "true"));
            }
            if (h.numChildren(clu) > 0) {
                StringBuilder buf = new StringBuilder();
                It it = h.iterChildren(clu);
                while (it.valid()) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(((Cluster)it.get()).getName());
                    it.advance();
                }
                LOG.statistics((Statistic)new StringStatistic(p + "children", buf.toString()));
            }
            ++cnum;
        }
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs == null || crs.isEmpty()) {
            return;
        }
        for (Clustering<Model> c : crs) {
            LogClusterSizes.logClusterSizes(c);
        }
    }
}

