/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.evaluation.clustering.ClusterContingencyTable;
import elki.utilities.datastructures.KuhnMunkresStern;
import elki.utilities.documentation.Reference;

@Reference(authors="M. J. Zaki and W. Meira Jr.", title="Clustering Validation", booktitle="Data Mining and Analysis: Fundamental Concepts and Algorithms", url="https://dataminingbook.info/book_html/chap17/book.html", bibkey="DBLP:books/cu/ZM2014")
public class MaximumMatchingAccuracy {
    protected double accuracy;

    public MaximumMatchingAccuracy(ClusterContingencyTable table) {
        int[][] cont = table.contingency;
        int rowlen = table.size1;
        int collen = table.size2;
        int maxlen = Math.max(rowlen, collen);
        double[][] costs = new double[maxlen][maxlen];
        for (int i = 0; i < rowlen; ++i) {
            for (int j = 0; j < collen; ++j) {
                costs[i][j] = -cont[i][j];
            }
        }
        int[] chosen = new KuhnMunkresStern().run(costs);
        double correctAssociations = 0.0;
        for (int i = 0; i < rowlen; ++i) {
            correctAssociations += chosen[i] < collen ? (double)cont[i][chosen[i]] : 0.0;
        }
        this.accuracy = correctAssociations / (double)cont[rowlen][collen];
    }

    public double getAccuracy() {
        return this.accuracy;
    }
}

