/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.evaluation.clustering.ClusterContingencyTable;
import elki.logging.LoggingUtil;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Reference;

public class PairCounting {
    protected long inBoth;
    protected long inFirst;
    protected long inSecond;
    protected long inNone;

    protected PairCounting(ClusterContingencyTable table) {
        int size;
        int[][] contingency = table.contingency;
        boolean breakNoise = table.breakNoiseClusters;
        boolean selfPair = table.selfPairing;
        if (!table.isStrictPartitioning()) {
            LoggingUtil.warning((String)("PairCounting F-Measure is not well defined for overlapping and incomplete clusterings. The number of elements are: " + contingency[table.size1][table.size2 + 1] + " != " + contingency[table.size1 + 1][table.size2] + " elements."));
        }
        long inB = 0L;
        long in1 = 0L;
        long in2 = 0L;
        for (int i = 0; i < table.size1; ++i) {
            size = contingency[i][table.size2 + 1];
            if (breakNoise && BitsUtil.get((long[])table.noise1, (int)i)) {
                if (!selfPair) continue;
                in1 += (long)size;
                continue;
            }
            in1 += (long)size * (long)(selfPair ? size : size - 1);
        }
        for (int j = 0; j < table.size2; ++j) {
            size = contingency[table.size1 + 1][j];
            if (breakNoise && BitsUtil.get((long[])table.noise2, (int)j)) {
                if (!selfPair) continue;
                in2 += (long)size;
                continue;
            }
            in2 += (long)size * (long)(selfPair ? size : size - 1);
        }
        for (int i1 = 0; i1 < table.size1; ++i1) {
            for (int i2 = 0; i2 < table.size2; ++i2) {
                int size2 = contingency[i1][i2];
                if (breakNoise && (BitsUtil.get((long[])table.noise1, (int)i1) || BitsUtil.get((long[])table.noise2, (int)i2))) {
                    if (!selfPair) continue;
                    inB += (long)size2;
                    continue;
                }
                inB += (long)size2 * (long)(selfPair ? size2 : size2 - 1);
            }
        }
        int tsize = contingency[table.size1][table.size2];
        long total = (long)tsize * (long)(selfPair ? tsize : tsize - 1);
        this.inBoth = inB;
        this.inFirst = in1 - inB;
        this.inSecond = in2 - inB;
        this.inNone = total - (inB + this.inFirst + this.inSecond);
    }

    public double fMeasure(double beta) {
        double beta2 = beta * beta;
        return (1.0 + beta2) * (double)this.inBoth / ((1.0 + beta2) * (double)this.inBoth + beta2 * (double)this.inFirst + (double)this.inSecond);
    }

    public double f1Measure() {
        return 2.0 * (double)this.inBoth / (2.0 * (double)this.inBoth + (double)this.inFirst + (double)this.inSecond);
    }

    public double precision() {
        return (double)this.inBoth / (double)(this.inBoth + this.inSecond);
    }

    public double recall() {
        return (double)this.inBoth / (double)(this.inBoth + this.inFirst);
    }

    @Reference(authors="E. B. Fowlkes, C. L. Mallows", title="A method for comparing two hierarchical clusterings", booktitle="Journal of the American Statistical Association, Vol. 78 Issue 383", url="https://doi.org/10.2307/2288117", bibkey="doi:10.2307/2288117")
    public double fowlkesMallows() {
        return Math.sqrt(this.precision() * this.recall());
    }

    @Reference(authors="W. M. Rand", title="Objective Criteria for the Evaluation of Clustering Methods", booktitle="Journal of the American Statistical Association, Vol. 66 Issue 336", url="https://doi.org/10.2307/2284239", bibkey="doi:10.2307/2284239")
    public double randIndex() {
        return (double)(this.inBoth + this.inNone) / (double)(this.inBoth + this.inFirst + this.inSecond + this.inNone);
    }

    @Reference(authors="L. Hubert, P. Arabie", title="Comparing partitions", booktitle="Journal of Classification 2(193)", url="https://doi.org/10.1007/BF01908075", bibkey="doi:10.1007/BF01908075")
    public double adjustedRandIndex() {
        double d = Math.sqrt((double)this.inBoth + (double)this.inFirst + (double)this.inSecond + (double)this.inNone);
        double exp = (double)(this.inBoth + this.inFirst) / d * (double)(this.inBoth + this.inSecond) / d;
        double opt = (double)this.inBoth + 0.5 * (double)(this.inFirst + this.inSecond);
        return ((double)this.inBoth - exp) / (opt - exp);
    }

    @Reference(authors="P. Jaccard", title="Distribution de la florine alpine dans la Bassin de Dranses et dans quelques regiones voisines", booktitle="Bulletin del la Soci\u00e9t\u00e9 Vaudoise des Sciences Naturelles", url="http://data.rero.ch/01-R241574160", bibkey="journals/misc/Jaccard1902")
    public double jaccard() {
        return (double)this.inBoth / (double)(this.inBoth + this.inFirst + this.inSecond);
    }

    @Reference(authors="B. Mirkin", title="Mathematical Classification and Clustering", booktitle="Nonconvex Optimization and Its Applications", url="https://doi.org/10.1007/978-1-4613-0457-9", bibkey="doi:10.1007/978-1-4613-0457-9")
    public long mirkin() {
        return this.inFirst + this.inSecond;
    }
}

