/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.evaluation.clustering.ClusterContingencyTable;
import elki.utilities.datastructures.KuhnMunkresStern;
import elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="M. Rezaei and F. Pasi", title="Set Matching Measures for External Cluster Validity", booktitle="IEEE Transactions on Knowledge and Data Engineering 28(8)", url="https://doi.org/10.1109/TKDE.2016.2551240", bibkey="DBLP:journals/tkde/RezaeiF16")
public class PairSetsIndex {
    protected double simplifiedPSI = 0.0;
    protected double psi = 0.0;

    public PairSetsIndex(ClusterContingencyTable table) {
        int rowlen = table.size1;
        int collen = table.size2;
        if (rowlen == collen && rowlen == 1) {
            this.psi = 1.0;
            this.simplifiedPSI = 1.0;
            return;
        }
        int[][] cont = table.contingency;
        int maxlen = Math.max(rowlen, collen);
        double[][] costs = new double[maxlen][maxlen];
        for (int i = 0; i < rowlen; ++i) {
            int rowsum = cont[i][collen];
            if (rowsum <= 0) continue;
            for (int j = 0; j < collen; ++j) {
                costs[i][j] = cont[i][j] > 0 ? (double)(-cont[i][j]) / (double)Math.max(cont[rowlen][j], rowsum) : 0.0;
            }
        }
        int[] chosen = new KuhnMunkresStern().run(costs);
        double s = 0.0;
        for (int i = 0; i < maxlen; ++i) {
            s += -costs[i][chosen[i]];
        }
        int[] firstlevelOrder = new int[rowlen];
        for (int i = 0; i < rowlen; ++i) {
            firstlevelOrder[i] = cont[i][collen];
        }
        int[] secondlevelOrder = new int[collen];
        for (int i = 0; i < collen; ++i) {
            secondlevelOrder[i] = cont[rowlen][i];
        }
        Arrays.sort(firstlevelOrder);
        Arrays.sort(secondlevelOrder);
        double e = 0.0;
        int minlength = Math.min(rowlen, collen);
        for (int i = 0; i < minlength; ++i) {
            e += (double)(firstlevelOrder[i] * secondlevelOrder[i]) / (double)cont[rowlen][collen] / (double)Math.max(firstlevelOrder[i], secondlevelOrder[i]);
        }
        this.simplifiedPSI = s < 1.0 ? 0.0 : (s - 1.0) / (double)(Math.max(rowlen, collen) - 1);
        this.psi = s < e ? 0.0 : (s - e) / ((double)Math.max(rowlen, collen) - e);
    }

    public double psi() {
        return this.psi;
    }

    public double simplifiedPSI() {
        return this.simplifiedPSI;
    }
}

