/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering;

import elki.evaluation.clustering.ClusterContingencyTable;
import elki.utilities.documentation.Reference;

@Reference(authors="M. Meil\u0103", title="Comparing clusterings", booktitle="University of Washington, Seattle, Technical Report 418", url="http://www.stat.washington.edu/mmp/Papers/compare-colt.pdf", bibkey="tr/washington/Meila02")
public class SetMatchingPurity {
    protected double smPurity = -1.0;
    protected double smInversePurity = -1.0;
    protected double smFFirst = -1.0;
    protected double smFSecond = -1.0;

    protected SetMatchingPurity(ClusterContingencyTable table) {
        int[][] contingency = table.contingency;
        int r = table.size1;
        int c = table.size2;
        double aggPurity = 0.0;
        double aggFirst = 0.0;
        for (int i = 0; i < r; ++i) {
            double precisionMax = 0.0;
            double fMax = 0.0;
            for (int j = 0; j < c; ++j) {
                precisionMax = Math.max(precisionMax, (double)contingency[i][j]);
                fMax = Math.max(fMax, 2.0 * (double)contingency[i][j] / (double)(contingency[i][c] + contingency[r][j]));
            }
            aggPurity += precisionMax;
            aggFirst += (double)contingency[i][c] * fMax;
        }
        double aggInvP = 0.0;
        double aggSecond = 0.0;
        for (int i = 0; i < c; ++i) {
            double recallMax = 0.0;
            double fMax = 0.0;
            for (int j = 0; j < r; ++j) {
                recallMax = Math.max(recallMax, (double)contingency[j][i]);
                fMax = Math.max(fMax, 2.0 * (double)contingency[j][i] / (double)(contingency[j][c] + contingency[r][i]));
            }
            aggInvP += recallMax;
            aggSecond += (double)contingency[r][i] * fMax;
        }
        int numobj = contingency[r][c];
        this.smPurity = aggPurity / (double)numobj;
        this.smFFirst = aggFirst / (double)numobj;
        this.smInversePurity = aggInvP / (double)numobj;
        this.smFSecond = aggSecond / (double)numobj;
    }

    @Reference(authors="Y. Zhao, G. Karypis", title="Criterion functions for document clustering: Experiments and analysis", booktitle="University of Minnesota, Dep. Computer Science, Technical Report 01-40", url="http://www-users.cs.umn.edu/~karypis/publications/Papers/PDF/vscluster.pdf", bibkey="tr/umn/ZhaoK01")
    public double purity() {
        return this.smPurity;
    }

    public double inversePurity() {
        return this.smInversePurity;
    }

    @Reference(authors="M. Steinbach, G. Karypis, V. Kumar", title="A Comparison of Document Clustering Techniques", booktitle="KDD workshop on text mining. Vol. 400. No. 1", url="http://glaros.dtc.umn.edu/gkhome/fetch/papers/docclusterKDDTMW00.pdf", bibkey="conf/kdd/SteinbachKK00")
    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.purity(), this.inversePurity());
    }

    @Reference(authors="E. Amig\u00f3, J. Gonzalo, J. Artiles, F. Verdejo", title="A comparison of extrinsic clustering evaluation metrics based on formal constraints", booktitle="Information Retrieval 12(5)", url="https://doi.org/10.1007/s10791-009-9106-z", bibkey="DBLP:journals/ir/AmigoGAV09a")
    public double fMeasureFirst() {
        return this.smFFirst;
    }

    @Reference(authors="E. Amig\u00f3, J. Gonzalo, J. Artiles, F. Verdejo", title="A comparison of extrinsic clustering evaluation metrics based on formal constraints", booktitle="Information Retrieval 12(5)", url="https://doi.org/10.1007/s10791-009-9106-z", bibkey="DBLP:journals/ir/AmigoGAV09a")
    public double fMeasureSecond() {
        return this.smFSecond;
    }
}

