/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.extractor;

import elki.Algorithm;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.hierarchical.extraction.CutDendrogramByHeight;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.evaluation.Evaluator;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.ChainedParameterization;
import elki.utilities.optionhandling.parameterization.ListParameterization;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.ArrayList;

public class CutDendrogramByHeightExtractor
implements Evaluator {
    private CutDendrogramByHeight inner;

    public CutDendrogramByHeightExtractor(CutDendrogramByHeight inner) {
        this.inner = inner;
    }

    public void processNewResult(Object newResult) {
        ArrayList hrs = ResultUtil.filterResults((Object)newResult, ClusterMergeHistory.class);
        for (ClusterMergeHistory pointerresult : hrs) {
            Metadata.hierarchyOf((Object)pointerresult).addChild(this.inner.run(pointerresult));
        }
    }

    public static class Par
    implements Parameterizer {
        CutDendrogramByHeight inner;

        public void configure(Parameterization config) {
            ListParameterization overrides = new ListParameterization();
            overrides.addParameter(Algorithm.Utils.ALGORITHM_ID, DummyHierarchicalClusteringAlgorithm.class);
            ChainedParameterization list = new ChainedParameterization(new Parameterization[]{overrides, config});
            list.errorsTo(config);
            this.inner = (CutDendrogramByHeight)list.tryInstantiate(CutDendrogramByHeight.class);
        }

        public CutDendrogramByHeightExtractor make() {
            return new CutDendrogramByHeightExtractor(this.inner);
        }
    }

    protected static class DummyHierarchicalClusteringAlgorithm
    implements HierarchicalClusteringAlgorithm {
        public TypeInformation[] getInputTypeRestriction() {
            return TypeUtil.array((TypeInformation[])new TypeInformation[0]);
        }

        @Override
        public ClusterMergeHistory autorun(Database db) {
            throw new AbortException("This must not be called");
        }
    }
}

