/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.extractor;

import elki.Algorithm;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.extraction.HDBSCANHierarchyExtraction;
import elki.data.Clustering;
import elki.data.model.DendrogramModel;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.extractor.CutDendrogramByHeightExtractor;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.ChainedParameterization;
import elki.utilities.optionhandling.parameterization.ListParameterization;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.ArrayList;

public class HDBSCANHierarchyExtractionEvaluator
implements Evaluator {
    private HDBSCANHierarchyExtraction inner;

    public HDBSCANHierarchyExtractionEvaluator(HDBSCANHierarchyExtraction inner) {
        this.inner = inner;
    }

    public void processNewResult(Object newResult) {
        ArrayList hrs = ResultUtil.filterResults((Object)newResult, ClusterMergeHistory.class);
        for (ClusterMergeHistory pointerresult : hrs) {
            Clustering<DendrogramModel> result = this.inner.run(pointerresult);
            Metadata.hierarchyOf((Object)pointerresult).addChild(result);
        }
    }

    public static class Par
    implements Parameterizer {
        HDBSCANHierarchyExtraction inner;

        public void configure(Parameterization config) {
            ListParameterization overrides = new ListParameterization();
            overrides.addParameter(Algorithm.Utils.ALGORITHM_ID, CutDendrogramByHeightExtractor.DummyHierarchicalClusteringAlgorithm.class);
            ChainedParameterization list = new ChainedParameterization(new Parameterization[]{overrides, config});
            this.inner = (HDBSCANHierarchyExtraction)ClassGenericsUtil.parameterizeOrAbort(HDBSCANHierarchyExtraction.class, (Parameterization)list);
        }

        public HDBSCANHierarchyExtractionEvaluator make() {
            return new HDBSCANHierarchyExtractionEvaluator(this.inner);
        }
    }
}

