/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.datastructures.heap.DoubleHeap;
import elki.utilities.datastructures.heap.DoubleMaxHeap;
import elki.utilities.datastructures.heap.DoubleMinHeap;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="L. J. Hubert, J. R. Levin", title="A general statistical framework for assessing categorical clustering in free recall", booktitle="Psychological Bulletin, Vol. 83(6)", url="https://doi.org/10.1037/0033-2909.83.6.1072", bibkey="doi:10.1037/0033-2909.83.6.1072")
public class CIndex<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(CIndex.class);
    private NoiseHandling noiseOption;
    private Distance<? super O> distance;
    private String key = CIndex.class.getName();

    public CIndex(Distance<? super O> distance, NoiseHandling noiseOpt) {
        this.distance = distance;
        this.noiseOption = noiseOpt;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Relation<? extends O> rel, DistanceQuery<O> dq, Clustering<?> c) {
        clusters = c.getAllClusters();
        ignorednoise = 0;
        w = 0;
        block9: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        ignorednoise += cluster.size();
                        continue block9;
                    }
                    case 2: {
                        continue block9;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        CIndex.LOG.warning((CharSequence)("Unknown noise handling option: " + (Object)this.noiseOption));
                    }
                }
            }
            w += cluster.size() * (cluster.size() - 1) >>> 1;
        }
        maxDists = new DoubleMinHeap(w);
        minDists = new DoubleMaxHeap(w);
        theta = 0.0;
        prog = CIndex.LOG.isVerbose() != false ? new FiniteProgress("Processing clusters for C-Index", clusters.size(), CIndex.LOG) : null;
        block10: for (i = 0; i < clusters.size(); ++i) {
            cluster = clusters.get(i);
            if (cluster.size() > 1 && !cluster.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                case 1: {
                    CIndex.LOG.incrementProcessed((AbstractProgress)prog);
                    continue block10;
                }
                case 2: {
                    this.processSingleton(cluster, rel, dq, (DoubleHeap)maxDists, (DoubleHeap)minDists, w);
                    CIndex.LOG.incrementProcessed((AbstractProgress)prog);
                    continue block10;
                }
                default: lbl-1000:
                // 2 sources

                {
                    theta += this.processCluster(cluster, clusters, i, dq, (DoubleHeap)maxDists, (DoubleHeap)minDists, w);
                    CIndex.LOG.incrementProcessed((AbstractProgress)prog);
                }
            }
        }
        CIndex.LOG.ensureCompleted(prog);
        min = 0.0;
        max = 0.0;
        if (!CIndex.$assertionsDisabled && minDists.size() != w) {
            throw new AssertionError();
        }
        if (!CIndex.$assertionsDisabled && maxDists.size() != w) {
            throw new AssertionError();
        }
        it = minDists.unsortedIter();
        while (it.valid()) {
            min += it.get();
            it.advance();
        }
        it = maxDists.unsortedIter();
        while (it.valid()) {
            max += it.get();
            it.advance();
        }
        if (!CIndex.$assertionsDisabled && !(max >= min)) {
            throw new AssertionError();
        }
        v0 = cIndex = max > min ? (theta - min) / (max - min) : 1.0;
        if (CIndex.LOG.isStatistics()) {
            CIndex.LOG.statistics((Statistic)new StringStatistic(this.key + ".c-index.noise-handling", this.noiseOption.toString()));
            if (ignorednoise > 0) {
                CIndex.LOG.statistics((Statistic)new LongStatistic(this.key + ".c-index.ignored", (long)ignorednoise));
            }
            CIndex.LOG.statistics((Statistic)new DoubleStatistic(this.key + ".c-index", cIndex));
        }
        ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("C-Index", cIndex, 0.0, 1.0, 0.0, true);
        if (!Metadata.hierarchyOf(c).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        return cIndex;
    }

    /*
     * Unable to fully structure code
     */
    protected double processCluster(Cluster<?> cluster, List<? extends Cluster<?>> clusters, int i, DistanceQuery<O> dq, DoubleHeap maxDists, DoubleHeap minDists, int w) {
        theta = 0.0;
        it1 = cluster.getIDs().iter();
        while (it1.valid()) {
            block5: for (j = i; j < clusters.size(); ++j) {
                ocluster = clusters.get(j);
                if (ocluster.size() > 1 && !ocluster.isNoise()) ** GOTO lbl-1000
                switch (1.$SwitchMap$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        continue block5;
                    }
                    ** case 2:
lbl11:
                    // 2 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        it2 = ocluster.getIDs().iter();
                        while (it2.valid()) {
                            if (i != j || DBIDUtil.compare((DBIDRef)it1, (DBIDRef)it2) > 0) {
                                dist = dq.distance((DBIDRef)it1, (DBIDRef)it2);
                                minDists.add(dist, w);
                                maxDists.add(dist, w);
                                if (ocluster == cluster) {
                                    theta += dist;
                                }
                            }
                            it2.advance();
                        }
                        break block0;
                    }
                }
            }
            it1.advance();
        }
        return theta;
    }

    protected void processSingleton(Cluster<?> cluster, Relation<? extends O> rel, DistanceQuery<O> dq, DoubleHeap maxDists, DoubleHeap minDists, int w) {
        DBIDIter it1 = cluster.getIDs().iter();
        while (it1.valid()) {
            DBIDIter it2 = rel.iterDBIDs();
            while (it2.valid()) {
                if (DBIDUtil.compare((DBIDRef)it1, (DBIDRef)it2) > 0) {
                    double dist = dq.distance((DBIDRef)it1, (DBIDRef)it2);
                    minDists.add(dist, w);
                    maxDists.add(dist, w);
                }
                it2.advance();
            }
            it1.advance();
        }
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)result);
        Relation relation = db.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(relation, dq, c);
        }
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("c-index.distance", "Distance function to use for computing the c-index.");
        public static final OptionID NOISE_ID = new OptionID("c-index.noisehandling", "Control how noise should be treated.");
        private Distance<? super O> distance;
        private NoiseHandling noiseOption;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTANCE_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new EnumParameter(NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseOption = x;
            });
        }

        public CIndex<O> make() {
            return new CIndex<O>(this.distance, this.noiseOption);
        }
    }
}

