/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.model.ModelUtil;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.Parameter;
import java.util.List;

public class ClusterRadius
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(ClusterRadius.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistance<?> distance;
    private String key = ClusterRadius.class.getName();

    public ClusterRadius(NumberVectorDistance<?> distance, NoiseHandling noiseOption) {
        this.distance = distance;
        this.noiseOption = noiseOption;
    }

    public double evaluateClustering(Database db, Relation<? extends NumberVector> rel, Clustering<?> c) {
        List<Cluster<?>> clusters = c.getAllClusters();
        double weighted = 0.0;
        double unweighted = 0.0;
        int cnum = 0;
        block4: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseOption) {
                    case IGNORE_NOISE: {
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        break;
                    }
                }
            }
            NumberVector center = ModelUtil.getPrototypeOrCentroid(cluster.getModel(), rel, cluster.getIDs());
            double max = 0.0;
            DBIDIter it1 = cluster.getIDs().iter();
            while (it1.valid()) {
                double d = this.distance.distance(center, (NumberVector)rel.get((DBIDRef)it1));
                max = Math.max(max, d);
                it1.advance();
            }
            ++cnum;
            weighted += max * (double)cluster.size();
            unweighted += max;
        }
        weighted /= (double)rel.size();
        unweighted /= (double)cnum;
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(this.key + ".weighted", weighted));
            LOG.statistics((Statistic)new DoubleStatistic(this.key + ".unweighted", unweighted));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based Evaluation");
        g.addMeasure("Weighted radius sum", weighted, 0.0, Double.POSITIVE_INFINITY, true);
        g.addMeasure("Radius sum", unweighted, 0.0, Double.POSITIVE_INFINITY, true);
        Metadata.hierarchyOf(c).addChild((Object)ev);
        return weighted;
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)result);
        Relation rel = db.getRelation((TypeInformation)this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering(db, (Relation<? extends NumberVector>)rel, c);
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("ssq.distance", "Distance function to use for computing the SSQ.");
        public static final OptionID NOISE_ID = new OptionID("ssq.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistance<?> distance;
        private NoiseHandling noiseOption;

        public void configure(Parameterization config) {
            EnumParameter noiseP;
            ObjectParameter distP = new ObjectParameter(DISTANCE_ID, NumberVectorDistance.class, SquaredEuclideanDistance.class);
            if (config.grab((Parameter)distP)) {
                this.distance = (NumberVectorDistance)distP.instantiateClass(config);
            }
            if (config.grab((Parameter)(noiseP = new EnumParameter(NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS)))) {
                this.noiseOption = (NoiseHandling)((Object)noiseP.getValue());
            }
        }

        public ClusterRadius make() {
            return new ClusterRadius(this.distance, this.noiseOption);
        }
    }
}

