/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;
import java.util.List;

@Reference(authors="F. B. Baker, L. J. Hubert", title="Measuring the Power of Hierarchical Cluster Analysis", booktitle="Journal of the American Statistical Association, 70(349)", url="https://doi.org/10.1080/01621459.1975.10480256", bibkey="doi:10.1080/01621459.1975.10480256")
public class ConcordantPairsGammaTau
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(ConcordantPairsGammaTau.class);
    private NoiseHandling noiseHandling;
    private PrimitiveDistance<? super NumberVector> distance;
    private String key = ConcordantPairsGammaTau.class.getName();

    public ConcordantPairsGammaTau(PrimitiveDistance<? super NumberVector> distance, NoiseHandling noiseHandling) {
        this.distance = distance;
        this.noiseHandling = noiseHandling;
    }

    public double evaluateClustering(Relation<? extends NumberVector> rel, Clustering<?> c) {
        List<Cluster<?>> clusters = c.getAllClusters();
        int ignorednoise = 0;
        int withinPairs = 0;
        block4: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseHandling) {
                    case IGNORE_NOISE: {
                        ignorednoise += cluster.size();
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            if ((withinPairs += cluster.size() * (cluster.size() - 1) >>> 1) >= 0) continue;
            throw new AbortException("Integer overflow - clusters too large to compute pairwise distances.");
        }
        double[] withinDistances = this.computeWithinDistances(rel, clusters, withinPairs);
        int[] withinTies = new int[withinDistances.length];
        this.countTies(withinDistances, withinTies);
        long concordantPairs = 0L;
        long discordantPairs = 0L;
        long betweenPairs = 0L;
        for (int i = 0; i < clusters.size(); ++i) {
            Cluster<?> ocluster1 = clusters.get(i);
            if ((ocluster1.size() <= 1 || ocluster1.isNoise()) && this.noiseHandling.equals((Object)NoiseHandling.IGNORE_NOISE)) continue;
            for (int j = i + 1; j < clusters.size(); ++j) {
                Cluster<?> ocluster2 = clusters.get(j);
                if ((ocluster2.size() <= 1 || ocluster2.isNoise()) && this.noiseHandling.equals((Object)NoiseHandling.IGNORE_NOISE)) continue;
                betweenPairs += (long)ocluster1.size() * (long)ocluster2.size();
                DBIDIter oit1 = ocluster1.getIDs().iter();
                while (oit1.valid()) {
                    NumberVector obj = (NumberVector)rel.get((DBIDRef)oit1);
                    DBIDIter oit2 = ocluster2.getIDs().iter();
                    while (oit2.valid()) {
                        double dist = this.distance.distance((Object)obj, rel.get((DBIDRef)oit2));
                        int p = Arrays.binarySearch(withinDistances, dist);
                        if (p >= 0) {
                            while (p > 0 && withinDistances[p - 1] >= dist) {
                                --p;
                            }
                            concordantPairs += (long)p;
                            discordantPairs += (long)(withinDistances.length - p - withinTies[p]);
                        } else {
                            p = -p - 1;
                            concordantPairs += (long)p;
                            discordantPairs += (long)(withinDistances.length - p);
                        }
                        oit2.advance();
                    }
                    oit1.advance();
                }
            }
        }
        long t = (long)(rel.size() - ignorednoise) * (long)(rel.size() - ignorednoise - 1) >>> 1;
        long tt = t * (t - 1L) >>> 1;
        double gamma = (double)(concordantPairs - discordantPairs) / (double)(concordantPairs + discordantPairs);
        double tau = this.computeTau(concordantPairs, discordantPairs, tt, withinDistances.length, betweenPairs);
        gamma = gamma > 0.0 ? gamma : 0.0;
        double d = tau = tau > 0.0 ? tau : 0.0;
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new StringStatistic(this.key + ".noise-handling", this.noiseHandling.toString()));
            if (ignorednoise > 0) {
                LOG.statistics((Statistic)new LongStatistic(this.key + ".ignored", (long)ignorednoise));
            }
            LOG.statistics((Statistic)new DoubleStatistic(this.key + ".gamma", gamma));
            LOG.statistics((Statistic)new DoubleStatistic(this.key + ".tau", tau));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Concordance");
        g.addMeasure("Gamma", gamma, -1.0, 1.0, 0.0, false);
        g.addMeasure("Tau", tau, -1.0, 1.0, 0.0, false);
        if (!Metadata.hierarchyOf(c).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        return gamma;
    }

    protected int countTies(double[] withinDistances, int[] withinTies) {
        int wties = 0;
        int running = 1;
        for (int i = 1; i <= withinDistances.length; ++i) {
            if (i == withinDistances.length || withinDistances[i - 1] != withinDistances[i]) {
                for (int j = i - running; j < i; ++j) {
                    withinTies[j] = running;
                }
                wties += running - 1;
                running = 1;
                continue;
            }
            ++running;
        }
        return wties;
    }

    protected double[] computeWithinDistances(Relation<? extends NumberVector> rel, List<? extends Cluster<?>> clusters, int withinPairs) {
        double[] concordant = new double[withinPairs];
        int i = 0;
        block4: for (Cluster<?> cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseHandling) {
                    case IGNORE_NOISE: {
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            DBIDIter it1 = cluster.getIDs().iter();
            while (it1.valid()) {
                NumberVector obj = (NumberVector)rel.get((DBIDRef)it1);
                DBIDIter it2 = cluster.getIDs().iter();
                while (it2.valid()) {
                    if (DBIDUtil.compare((DBIDRef)it1, (DBIDRef)it2) > 0) {
                        concordant[i++] = this.distance.distance((Object)obj, rel.get((DBIDRef)it2));
                    }
                    it2.advance();
                }
                it1.advance();
            }
        }
        assert (concordant.length == i);
        Arrays.sort(concordant);
        return concordant;
    }

    @Reference(authors="F. J. Rohlf", title="Methods of comparing classifications", booktitle="Annual Review of Ecology and Systematics", url="https://doi.org/10.1146/annurev.es.05.110174.000533", bibkey="doi:10.1146/annurev.es.05.110174.000533")
    public double computeTau(long c, long d, double m, long wd, long bd) {
        double tie = wd * (wd - 1L) + bd * (bd - 1L) >>> 1;
        return (double)(c - d) / Math.sqrt((m - tie) * m);
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)result);
        Relation rel = db.getRelation((TypeInformation)this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering((Relation<? extends NumberVector>)rel, c);
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("concordant.distance", "Distance function to use for measuring concordant and discordant pairs.");
        public static final OptionID NOISE_ID = new OptionID("concordant-pairs.noisehandling", "Control how noise should be treated.");
        private PrimitiveDistance<NumberVector> distance;
        private NoiseHandling noiseHandling;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTANCE_ID, PrimitiveDistance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new EnumParameter(NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseHandling = x;
            });
        }

        public ConcordantPairsGammaTau make() {
            return new ConcordantPairsGammaTau(this.distance, this.noiseHandling);
        }
    }
}

