/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.Model;
import elki.data.type.CombinedTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.evaluation.Evaluator;
import elki.math.MathUtil;
import elki.math.geometry.PrimsMinimumSpanningTree;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="Davoud Moulavi, Pablo A. Jaskowiak, Ricardo J. G. B. Campello, Arthur Zimek, J\u00f6rg Sander", title="Density-Based Clustering Validation", booktitle="Proc. 14th SIAM International Conference on Data Mining (SDM)", url="https://doi.org/10.1137/1.9781611973440.96", bibkey="DBLP:conf/sdm/MoulaviJCZS14")
public class DBCV<O>
implements Evaluator {
    private Distance<? super O> distance;

    public DBCV(Distance<? super O> distance) {
        this.distance = distance;
    }

    public double evaluateClustering(Relation<O> relation, Clustering<?> cl) {
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        List<Cluster<?>> clusters = cl.getAllClusters();
        int numc = clusters.size();
        Relation<O> vrel = relation;
        int dim = RelationUtil.dimensionality(vrel);
        ArrayDBIDs[] cids = new ArrayDBIDs[numc];
        double[][] coreDists = new double[numc][];
        for (int c = 0; c < numc; ++c) {
            Cluster<?> cluster = clusters.get(c);
            if (cluster.isNoise() || cluster.size() < 2) {
                coreDists[c] = null;
                continue;
            }
            ArrayDBIDs ids = cids[c] = DBIDUtil.ensureArray((DBIDs)cluster.getIDs());
            coreDists[c] = new double[ids.size()];
            double[] clusterCoreDists = coreDists[c];
            DBIDArrayIter it = ids.iter();
            DBIDArrayIter it2 = ids.iter();
            while (it.valid()) {
                double currentCoreDist = 0.0;
                int neighbors = 0;
                it2.seek(0);
                while (it2.valid()) {
                    double dist;
                    if (!DBIDUtil.equal((DBIDRef)it, (DBIDRef)it2) && (dist = dq.distance((DBIDRef)it, (DBIDRef)it2)) > 0.0) {
                        currentCoreDist += MathUtil.powi((double)(1.0 / dist), (int)dim);
                        ++neighbors;
                    }
                    it2.advance();
                }
                clusterCoreDists[it.getOffset()] = FastMath.pow((double)(currentCoreDist / (double)neighbors), (double)(-1.0 / (double)dim));
                it.advance();
            }
        }
        int[][] clusterDegrees = new int[numc][];
        double[] clusterDscMax = new double[numc];
        boolean[] internalEdges = new boolean[numc];
        for (int c = 0; c < numc; ++c) {
            int i;
            Cluster<?> cluster = clusters.get(c);
            if (cluster.isNoise() || cluster.size() < 2) {
                clusterDegrees[c] = null;
                clusterDscMax[c] = Double.NaN;
                continue;
            }
            double[] clusterCoreDists = coreDists[c];
            ArrayDBIDs ids = cids[c];
            double dscMax = 0.0;
            double[][] distances = new double[cluster.size()][cluster.size()];
            DBIDArrayIter it = ids.iter();
            DBIDArrayIter it2 = ids.iter();
            while (it.valid()) {
                double currentCoreDist = clusterCoreDists[it.getOffset()];
                it2.seek(it.getOffset() + 1);
                while (it2.valid()) {
                    double mutualReachDist;
                    distances[it.getOffset()][it2.getOffset()] = mutualReachDist = MathUtil.max((double)currentCoreDist, (double)clusterCoreDists[it2.getOffset()], (double)dq.distance((DBIDRef)it, (DBIDRef)it2));
                    distances[it2.getOffset()][it.getOffset()] = mutualReachDist;
                    it2.advance();
                }
                it.advance();
            }
            int[] nodes = PrimsMinimumSpanningTree.processDense((double[][])distances);
            int[] degree = new int[cluster.size()];
            for (i = 0; i < nodes.length; ++i) {
                int n = nodes[i];
                degree[n] = degree[n] + 1;
            }
            int e = nodes.length - 1;
            for (i = 0; i < e; i += 2) {
                if (degree[nodes[i]] <= 1 || degree[nodes[i + 1]] <= 1) continue;
                internalEdges[c] = true;
            }
            clusterDegrees[c] = degree;
            e = nodes.length - 1;
            for (i = 0; i < e; i += 2) {
                int n1 = nodes[i];
                int n2 = nodes[i + 1];
                if (!(distances[n1][n2] > dscMax) || internalEdges[c] && (degree[n1] <= 1 || degree[n2] <= 1)) continue;
                dscMax = distances[n1][n2];
            }
            clusterDscMax[c] = dscMax;
        }
        double dbcv = 0.0;
        for (int c = 0; c < numc; ++c) {
            Cluster<?> cluster = clusters.get(c);
            if (cluster.isNoise() || cluster.size() < 2) continue;
            double currentDscMax = clusterDscMax[c];
            double[] clusterCoreDists = coreDists[c];
            int[] currentDegree = clusterDegrees[c];
            double dspcMin = Double.POSITIVE_INFINITY;
            DBIDArrayIter it = cids[c].iter();
            while (it.valid()) {
                if (currentDegree[it.getOffset()] >= 2 || cluster.size() <= 2) {
                    double currentCoreDist = clusterCoreDists[it.getOffset()];
                    for (int oc = 0; oc < numc; ++oc) {
                        Cluster<?> ocluster = clusters.get(oc);
                        if (ocluster.isNoise() || ocluster.size() < 2 || cluster == ocluster) continue;
                        int[] oDegree = clusterDegrees[oc];
                        double[] oclusterCoreDists = coreDists[oc];
                        DBIDArrayIter it2 = cids[oc].iter();
                        while (it2.valid()) {
                            if (oDegree[it2.getOffset()] >= 2 || cluster.size() <= 2) {
                                double mutualReachDist = MathUtil.max((double)currentCoreDist, (double)oclusterCoreDists[it2.getOffset()], (double)dq.distance((DBIDRef)it, (DBIDRef)it2));
                                dspcMin = mutualReachDist < dspcMin ? mutualReachDist : dspcMin;
                            }
                            it2.advance();
                        }
                    }
                }
                it.advance();
            }
            double vc = (dspcMin - currentDscMax) / MathUtil.max((double)dspcMin, (double)currentDscMax);
            double weight = (double)cluster.size() / (double)relation.size();
            dbcv += weight * vc;
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(cl, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Density Based Clustering Validation", dbcv, 0.0, Double.POSITIVE_INFINITY, 0.0, true);
        if (!Metadata.hierarchyOf(cl).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        return dbcv;
    }

    public void processNewResult(Object newResult) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(newResult);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)newResult);
        CombinedTypeInformation typ = new CombinedTypeInformation(new TypeInformation[]{this.distance.getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD});
        Relation rel = db.getRelation((TypeInformation)typ, new Object[0]);
        if (rel != null) {
            for (Clustering<Model> cl : crs) {
                this.evaluateClustering(rel, cl);
            }
        }
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("dbcv.distance", "Distance function to use for computing the dbcv.");
        private Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTANCE_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
        }

        public DBCV<O> make() {
            return new DBCV<O>(this.distance);
        }
    }
}

