/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.clustering.internal;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.LPNormDistance;
import elki.distance.subspace.SubspaceLPNormDistance;
import elki.evaluation.Evaluator;
import elki.evaluation.clustering.internal.NoiseHandling;
import elki.evaluation.clustering.internal.SimplifiedSilhouette;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.math.Mean;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Iterator;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="D. L. Davies, D. W. Bouldin", title="A Cluster Separation Measure", booktitle="IEEE Transactions Pattern Analysis and Machine Intelligence 1(2)", url="https://doi.org/10.1109/TPAMI.1979.4766909", bibkey="DBLP:journals/pami/DaviesB79")
public class DaviesBouldinIndex
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(DaviesBouldinIndex.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistance<?> distance;
    private double p;
    private String key = DaviesBouldinIndex.class.getName();

    public DaviesBouldinIndex(NumberVectorDistance<?> distance, NoiseHandling noiseOpt, double p) {
        if (noiseOpt == NoiseHandling.TREAT_NOISE_AS_SINGLETONS) {
            LOG.warning((CharSequence)"NoiseHandling.TREAT_NOISE_AS_SINGLETONS is currently not supported correctly by DaviesBouldinIndex.");
        }
        this.distance = distance;
        this.noiseOption = noiseOpt;
        this.p = p;
    }

    public double evaluateClustering(Relation<? extends NumberVector> rel, Clustering<?> c) {
        double daviesBouldinMean;
        List<Cluster<?>> clusters = c.getAllClusters();
        NumberVector[] centroids = new NumberVector[clusters.size()];
        int noisecount = SimplifiedSilhouette.centroids(rel, clusters, centroids, this.noiseOption);
        double[] withinGroupDistance = this.withinGroupDistances(rel, clusters, centroids);
        Mean daviesBouldin = new Mean();
        for (int i = 0; i < clusters.size(); ++i) {
            NumberVector centroid = centroids[i];
            double withinGroupDistancei = withinGroupDistance[i];
            double max = 0.0;
            for (int j = 0; j < clusters.size(); ++j) {
                double d2;
                double d;
                NumberVector ocentroid = centroids[j];
                if (ocentroid == centroid) continue;
                if (centroid != null && ocentroid != null) {
                    double bD = this.distance.distance(centroid, ocentroid);
                    double d3 = (withinGroupDistancei + withinGroupDistance[j]) / bD;
                    max = d3 > max ? d3 : max;
                    continue;
                }
                if (this.noiseOption == NoiseHandling.IGNORE_NOISE) continue;
                if (centroid != null) {
                    d = Double.POSITIVE_INFINITY;
                    DBIDIter it = clusters.get(j).getIDs().iter();
                    while (it.valid()) {
                        d2 = this.distance.distance(centroid, (NumberVector)rel.get((DBIDRef)it));
                        d = d2 < d ? d2 : d;
                        it.advance();
                    }
                    max = (d = withinGroupDistancei / d) > max ? d : max;
                    continue;
                }
                if (ocentroid == null) continue;
                d = Double.POSITIVE_INFINITY;
                DBIDIter it = clusters.get(i).getIDs().iter();
                while (it.valid()) {
                    d2 = this.distance.distance((NumberVector)rel.get((DBIDRef)it), ocentroid);
                    d = d2 < d ? d2 : d;
                    it.advance();
                }
                max = (d = withinGroupDistance[j] / d) > max ? d : max;
            }
            daviesBouldin.put(max);
        }
        double d = daviesBouldinMean = daviesBouldin.getCount() > 1.0 ? daviesBouldin.getMean() : 2.0;
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new StringStatistic(this.key + ".db-index.noise-handling", this.noiseOption.toString()));
            if (noisecount > 0) {
                LOG.statistics((Statistic)new LongStatistic(this.key + ".db-index.ignored", (long)noisecount));
            }
            LOG.statistics((Statistic)new DoubleStatistic(this.key + ".db-index", daviesBouldinMean));
        }
        EvaluationResult ev = EvaluationResult.findOrCreate(c, (String)"Internal Clustering Evaluation");
        EvaluationResult.MeasurementGroup g = ev.findOrCreateGroup("Distance-based");
        g.addMeasure("Davies Bouldin Index", daviesBouldinMean, 0.0, Double.POSITIVE_INFINITY, 0.0, true);
        if (!Metadata.hierarchyOf(c).addChild((Object)ev)) {
            Metadata.of((Object)ev).notifyChanged();
        }
        return daviesBouldinMean;
    }

    public double[] withinGroupDistances(Relation<? extends NumberVector> rel, List<? extends Cluster<?>> clusters, NumberVector[] centroids) {
        double[] withinGroupDists = new double[clusters.size()];
        Iterator<Cluster<?>> ci = clusters.iterator();
        int i = 0;
        while (ci.hasNext()) {
            Cluster<?> cluster = ci.next();
            NumberVector centroid = centroids[i];
            if (centroid == null) {
                withinGroupDists[i] = 0.0;
            } else {
                double wD = 0.0;
                DBIDIter it = cluster.getIDs().iter();
                while (it.valid()) {
                    double dist = this.distance.distance(centroid, (NumberVector)rel.get((DBIDRef)it));
                    wD += this.p != 1.0 ? FastMath.pow((double)dist, (double)this.p) : dist;
                    it.advance();
                }
                withinGroupDists[i] = this.p != 1.0 ? FastMath.pow((double)wD, (double)(1.0 / this.p)) : (wD /= (double)cluster.size());
            }
            ++i;
        }
        return withinGroupDists;
    }

    public void processNewResult(Object result) {
        List<Clustering<Model>> crs = Clustering.getClusteringResults(result);
        if (crs.isEmpty()) {
            return;
        }
        Database db = ResultUtil.findDatabase((Object)result);
        Relation rel = db.getRelation((TypeInformation)this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<Model> c : crs) {
            this.evaluateClustering((Relation<? extends NumberVector>)rel, c);
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("davies-bouldin.distance", "Distance function to use for computing the davies-bouldin index.");
        public static final OptionID NOISE_ID = new OptionID("davies-bouldin.noisehandling", "Control how noise should be treated.");
        public static final OptionID POWER_ID = new OptionID("davies-bouldin.p", "Power exponent for computing the mean, defaults to the power of the Lp norm, if used.");
        private NumberVectorDistance<?> distance;
        private NoiseHandling noiseOption;
        private double p;

        public void configure(Parameterization config) {
            new ObjectParameter(DISTANCE_ID, NumberVectorDistance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new EnumParameter(NOISE_ID, NoiseHandling.class, (Enum)NoiseHandling.TREAT_NOISE_AS_SINGLETONS).grab(config, x -> {
                this.noiseOption = x;
            });
            double defaultp = this.distance instanceof LPNormDistance ? ((LPNormDistance)this.distance).getP() : (this.distance instanceof SubspaceLPNormDistance ? ((SubspaceLPNormDistance)this.distance).getP() : 1.0);
            new DoubleParameter(POWER_ID, defaultp).grab(config, x -> {
                this.p = x;
            });
        }

        public DaviesBouldinIndex make() {
            return new DaviesBouldinIndex(this.distance, this.noiseOption, this.p);
        }
    }
}

